/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.WinUACTemporaryFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import com.intellij.util.text.StringFactory;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;

public class FileUtil
extends FileUtilRt {
    public static final String ASYNC_DELETE_EXTENSION = ".__del__";
    public static final int REGEX_PATTERN_FLAGS = SystemInfo.isFileSystemCaseSensitive ? 0 : 2;
    public static final TObjectHashingStrategy<String> PATH_HASHING_STRATEGY = FilePathHashingStrategy.create();
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY = SystemInfo.isFileSystemCaseSensitive ? ContainerUtil.canonicalStrategy() : new TObjectHashingStrategy<File>(){

        public int computeHashCode(File object) {
            return FileUtil.fileHashCode(object);
        }

        public boolean equals(File o1, File o2) {
            return FileUtil.filesEqual(o1, o2);
        }
    };
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");

    public static String join(String ... parts) {
        return StringUtil.join(parts, File.separator);
    }

    public static String getRelativePath(File base, File file) {
        return FileUtilRt.getRelativePath(base, file);
    }

    public static String getRelativePath(String basePath, String filePath, char separator) {
        return FileUtilRt.getRelativePath(basePath, filePath, separator);
    }

    public static String getRelativePath(String basePath, String filePath, char separator, boolean caseSensitive) {
        return FileUtilRt.getRelativePath(basePath, filePath, separator, caseSensitive);
    }

    public static boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) {
        return FileUtil.isAncestor(ancestor.getPath(), file.getPath(), strict);
    }

    public static boolean isAncestor(String ancestor, String file, boolean strict) {
        return !ThreeState.NO.equals((Object)FileUtil.isAncestorThreeState(ancestor, file, strict));
    }

    public static ThreeState isAncestorThreeState(String ancestor, String file, boolean strict) {
        String ancestorPath = FileUtil.toCanonicalPath(ancestor);
        String filePath = FileUtil.toCanonicalPath(file);
        return FileUtil.startsWith(filePath, ancestorPath, strict, SystemInfo.isFileSystemCaseSensitive, true);
    }

    public static boolean startsWith(String path, String start) {
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, start, false, SystemInfo.isFileSystemCaseSensitive, false));
    }

    public static boolean startsWith(String path, String start, boolean caseSensitive) {
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, start, false, caseSensitive, false));
    }

    private static ThreeState startsWith(String path, String prefix, boolean strict, boolean caseSensitive, boolean checkImmediateParent) {
        char next1;
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return pathLength == 0 ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (prefixLength > pathLength) {
            return ThreeState.NO;
        }
        if (!path.regionMatches(!caseSensitive, 0, prefix, 0, prefixLength)) {
            return ThreeState.NO;
        }
        if (pathLength == prefixLength) {
            return strict ? ThreeState.NO : ThreeState.YES;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next1 = path.charAt(slashOrSeparatorIdx)) == '/' || next1 == File.separatorChar) {
            if (!checkImmediateParent) {
                return ThreeState.YES;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                return ThreeState.YES;
            }
            int idxNext = path.indexOf(next1, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next1 == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            return idxNext == -1 ? ThreeState.YES : ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    public static <T> Collection<T> removeAncestors(Collection<T> files, Convertor<T, String> convertor, PairProcessor<T, T> removeProcessor) {
        if (files.isEmpty()) {
            return files;
        }
        TreeMap<String, T> paths = new TreeMap<String, T>();
        for (T file : files) {
            String path = convertor.convert(file);
            assert (path != null);
            String canonicalPath = FileUtil.toCanonicalPath(path);
            paths.put(canonicalPath, file);
        }
        ArrayList ordered = new ArrayList(paths.entrySet());
        ArrayList result = new ArrayList(ordered.size());
        result.add(((Map.Entry)ordered.get(0)).getValue());
        for (int i = 1; i < ordered.size(); ++i) {
            Map.Entry entry = (Map.Entry)ordered.get(i);
            String child = (String)entry.getKey();
            boolean parentNotFound = true;
            for (int j = i - 1; j >= 0; --j) {
                String parent = (String)((Map.Entry)ordered.get(j)).getKey();
                if (parent == null || !FileUtil.startsWith(child, parent) || !removeProcessor.process(((Map.Entry)ordered.get(j)).getValue(), entry.getValue())) continue;
                parentNotFound = false;
                break;
            }
            if (!parentNotFound) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public static File getParentFile(File file) {
        return FileUtilRt.getParentFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileBytes(File file) throws IOException {
        byte[] bytes;
        FileInputStream stream = new FileInputStream(file);
        try {
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtil.isTooLarge(len)) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        return bytes;
    }

    public static boolean processFirstBytes(InputStream stream, int length, Processor<ByteSequence> processor) throws IOException {
        byte[] bytes = (byte[])BUFFER.get();
        assert (bytes.length >= length) : "Cannot process more than " + bytes.length + " in one call, requested:" + length;
        int n = stream.read(bytes, 0, length);
        if (n <= 0) {
            return false;
        }
        return processor.process(new ByteSequence(bytes, 0, n));
    }

    public static byte[] loadFirst(InputStream stream, int maxLength) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = (byte[])BUFFER.get();
        while (maxLength > 0 && (n = stream.read(bytes, 0, Math.min(maxLength, bytes.length))) > 0) {
            buffer.write(bytes, 0, n);
            maxLength -= n;
        }
        buffer.close();
        return buffer.toByteArray();
    }

    public static String loadTextAndClose(InputStream stream) throws IOException {
        return FileUtil.loadTextAndClose(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextAndClose(Reader reader) throws IOException {
        try {
            String string = StringFactory.createShared(FileUtil.adaptiveLoadText(reader));
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static char[] adaptiveLoadText(Reader reader) throws IOException {
        int n;
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        return result;
    }

    public static byte[] adaptiveLoadBytes(InputStream stream) throws IOException {
        int n;
        byte[] bytes = new byte[4096];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result = new byte[total];
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        return result;
    }

    public static Future<Void> asyncDelete(File file) {
        return FileUtil.asyncDelete(Collections.singleton(file));
    }

    public static Future<Void> asyncDelete(Collection<File> files) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file : files) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        if (!tempFiles.isEmpty()) {
            return FileUtil.startDeletionThread(tempFiles.toArray(new File[tempFiles.size()]));
        }
        return new FixedFuture<Object>(null);
    }

    private static Future<Void> startDeletionThread(final File ... tempFiles) {
        FutureTask<Object> deleteFilesTask = new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                int priority = currentThread.getPriority();
                currentThread.setPriority(1);
                try {
                    for (File tempFile : tempFiles) {
                        FileUtil.delete(tempFile);
                    }
                }
                finally {
                    currentThread.setPriority(priority);
                }
            }
        }, null);
        try {
            Class<?> aClass = Class.forName("com.intellij.openapi.application.ApplicationManager");
            Method getApplicationMethod = aClass.getMethod("getApplication", new Class[0]);
            Object application = getApplicationMethod.invoke(null, new Object[0]);
            Method executeOnPooledThreadMethod = application.getClass().getMethod("executeOnPooledThread", Runnable.class);
            executeOnPooledThreadMethod.invoke(application, deleteFilesTask);
        }
        catch (Exception ignored) {
            new Thread(deleteFilesTask, "File deletion thread").start();
        }
        return deleteFilesTask;
    }

    private static File renameToTempFileOrDelete(File file) {
        String originalFileName;
        File tempFile;
        String tempDir = FileUtil.getTempDirectory();
        boolean isSameDrive = true;
        if (SystemInfo.isWindows) {
            String tempDirDrive = tempDir.substring(0, 2);
            String fileDrive = file.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file);
        return null;
    }

    private static File getTempFile(String originalFileName, String parent) {
        int randomSuffix;
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        String name;
        File tempFile;
        while ((tempFile = new File(parent, name = "___" + originalFileName + i + ASYNC_DELETE_EXTENSION)).exists()) {
            ++i;
        }
        return tempFile;
    }

    public static boolean delete(File file) {
        if (FileUtilRt.NIOReflect.IS_AVAILABLE) {
            return FileUtil.deleteRecursivelyNIO(file);
        }
        return FileUtil.deleteRecursively(file);
    }

    private static boolean deleteRecursively(File file) {
        File[] files;
        FileAttributes attributes = FileSystemUtil.getAttributes(file);
        if (attributes == null) {
            return true;
        }
        if (attributes.isDirectory() && !attributes.isSymLink() && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (FileUtil.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtil.deleteFile(file);
    }

    public static boolean createParentDirs(File file) {
        return FileUtilRt.createParentDirs(file);
    }

    public static boolean createDirectory(File path) {
        return FileUtilRt.createDirectory(path);
    }

    public static boolean createIfDoesntExist(File file) {
        return FileUtilRt.createIfNotExists(file);
    }

    public static boolean ensureCanCreateFile(File file) {
        return FileUtilRt.ensureCanCreateFile(file);
    }

    public static void copy(File fromFile, File toFile) throws IOException {
        FileUtil.performCopy(fromFile, toFile, true);
    }

    public static void copyContent(File fromFile, File toFile) throws IOException {
        FileUtil.performCopy(fromFile, toFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCopy(File fromFile, File toFile, boolean syncTimestamp) throws IOException {
        FileOutputStream fos;
        try {
            fos = FileUtil.openOutputStream(toFile);
        }
        catch (IOException e) {
            if (SystemInfo.isWindows && e.getMessage() != null && e.getMessage().contains("denied") && WinUACTemporaryFix.nativeCopy(fromFile, toFile, syncTimestamp)) {
                return;
            }
            throw e;
        }
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtil.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        if (syncTimestamp) {
            long timeStamp = fromFile.lastModified();
            if (timeStamp < 0L) {
                LOG.warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
            } else if (!toFile.setLastModified(timeStamp)) {
                LOG.warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
            }
        }
        if (SystemInfo.isUnix && fromFile.canExecute()) {
            FileSystemUtil.clonePermissionsToExecute(fromFile.getPath(), toFile.getPath());
        }
    }

    private static FileOutputStream openOutputStream(File file) throws IOException {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                throw new IOException("Parent file is null for " + file.getPath(), e);
            }
            FileUtil.createParentDirs(file);
            return new FileOutputStream(file);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        FileUtilRt.copy(inputStream, outputStream);
    }

    public static void copy(InputStream inputStream, int maxSize, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = (byte[])BUFFER.get();
        for (int toRead = maxSize; toRead > 0 && (read = inputStream.read(buffer, 0, Math.min(buffer.length, toRead))) >= 0; toRead -= read) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDirContent(File fromDir, File toDir) throws IOException {
        File[] children;
        for (File child : children = ObjectUtils.notNull(fromDir.listFiles(), ArrayUtil.EMPTY_FILE_ARRAY)) {
            File target = new File(toDir, child.getName());
            if (child.isFile()) {
                FileUtil.copy(child, target);
                continue;
            }
            FileUtil.copyDir(child, target, true);
        }
    }

    public static void copyDir(File fromDir, File toDir, boolean copySystemFiles) throws IOException {
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !StringUtil.startsWithChar(file.getName(), '.');
            }
        });
    }

    public static void copyDir(File fromDir, File toDir, FileFilter filter) throws IOException {
        FileUtil.ensureExists(toDir);
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(CommonBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(CommonBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file : files) {
            if (filter != null && !filter.accept(file)) continue;
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), filter);
                continue;
            }
            FileUtil.copy(file, new File(toDir, file.getName()));
        }
    }

    public static void ensureExists(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException(CommonBundle.message("exception.directory.can.not.create", dir.getPath()));
        }
    }

    public static String getNameWithoutExtension(File file) {
        return FileUtil.getNameWithoutExtension(file.getName());
    }

    public static String getNameWithoutExtension(String name) {
        return FileUtilRt.getNameWithoutExtension(name);
    }

    public static String createSequentFileName(File aParentFolder, String aFilePrefix, String aExtension) {
        return FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
    }

    public static File findSequentNonexistentFile(File parentFolder, String filePrefix, String extension) {
        int postfix = 0;
        String ext = extension.isEmpty() ? "" : '.' + extension;
        File candidate = new File(parentFolder, filePrefix + ext);
        while (candidate.exists()) {
            candidate = new File(parentFolder, filePrefix + Integer.toString(++postfix) + ext);
        }
        return candidate;
    }

    public static String toSystemDependentName(String aFileName) {
        return FileUtilRt.toSystemDependentName(aFileName);
    }

    public static String toSystemIndependentName(String aFileName) {
        return FileUtilRt.toSystemIndependentName(aFileName);
    }

    public static String nameToCompare(String name) {
        return (SystemInfo.isFileSystemCaseSensitive ? name : name.toLowerCase()).replace('\\', '/');
    }

    public static String toCanonicalPath(String path) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true);
    }

    public static String toCanonicalPath(String path, char separatorChar) {
        return FileUtil.toCanonicalPath(path, separatorChar, true);
    }

    public static String toCanonicalUriPath(String path) {
        return FileUtil.toCanonicalPath(path, '/', false);
    }

    private static String toCanonicalPath(String path, char separatorChar, boolean removeLastSlash) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (".".equals(path)) {
            return "";
        }
        if ((path = path.replace(separatorChar, '/')).indexOf(47) == -1) {
            return path;
        }
        StringBuilder result = new StringBuilder(path.length());
        int start = FileUtil.processRoot(path, result);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    FileUtil.processDots(result, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result.append('.');
                }
                separator = false;
                continue;
            }
            if (dots > 0) {
                StringUtil.repeatSymbol(result, '.', dots);
                dots = 0;
            }
            result.append(c);
            separator = false;
        }
        if (dots > 0) {
            FileUtil.processDots(result, dots, start);
        }
        int lastChar = result.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result.charAt(lastChar) == '/' && lastChar > start) {
            result.deleteCharAt(lastChar);
        }
        return result.toString();
    }

    private static int processRoot(String path, StringBuilder result) {
        if (SystemInfo.isWindows && path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) == '/') {
            int shareStart;
            int hostStart;
            result.append("//");
            for (hostStart = 2; hostStart < path.length() && path.charAt(hostStart) == '/'; ++hostStart) {
            }
            if (hostStart == path.length()) {
                return hostStart;
            }
            int hostEnd = path.indexOf(47, hostStart);
            if (hostEnd < 0) {
                hostEnd = path.length();
            }
            result.append(path, hostStart, hostEnd);
            result.append('/');
            for (shareStart = hostEnd; shareStart < path.length() && path.charAt(shareStart) == '/'; ++shareStart) {
            }
            if (shareStart == path.length()) {
                return shareStart;
            }
            int shareEnd = path.indexOf(47, shareStart);
            if (shareEnd < 0) {
                shareEnd = path.length();
            }
            result.append(path, shareStart, shareEnd);
            result.append('/');
            return shareEnd;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private static void processDots(StringBuilder result, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!StringUtil.endsWith(result, "/../") && !StringUtil.equals(result, "../")) {
                pos = StringUtil.lastIndexOf(result, '/', start, result.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result.delete(pos, result.length());
            } else {
                result.append("../");
            }
        } else if (dots != 1) {
            StringUtil.repeatSymbol(result, '.', dots);
            result.append('/');
        }
    }

    public static String normalize(String path) {
        int start = 0;
        boolean separator = false;
        if (SystemInfo.isWindows) {
            if (path.startsWith("//")) {
                start = 2;
                separator = true;
            } else if (path.startsWith("\\\\")) {
                return FileUtil.normalizeTail(0, path, false);
            }
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (separator) {
                    return FileUtil.normalizeTail(i, path, true);
                }
                separator = true;
                continue;
            }
            if (c == '\\') {
                return FileUtil.normalizeTail(i, path, separator);
            }
            separator = false;
        }
        return path;
    }

    private static String normalizeTail(int prefixEnd, String path, boolean separator) {
        StringBuilder result = new StringBuilder(path.length());
        result.append(path, 0, prefixEnd);
        int start = prefixEnd;
        if (start == 0 && SystemInfo.isWindows && (path.startsWith("//") || path.startsWith("\\\\"))) {
            start = 2;
            result.append("//");
            separator = true;
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (!separator) {
                    result.append('/');
                }
                separator = true;
                continue;
            }
            result.append(c);
            separator = false;
        }
        return result.toString();
    }

    public static String unquote(String urlString) {
        urlString = urlString.replace('/', File.separatorChar);
        return URLUtil.unescapePercentSequences(urlString);
    }

    public static boolean isFilePathAcceptable(File root, FileFilter fileFilter) {
        if (fileFilter == null) {
            return true;
        }
        File file = root;
        do {
            if (fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static void rename(File source, File target) throws IOException {
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean filesEqual(File file1, File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(String path1, String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return PATH_HASHING_STRATEGY.equals((Object)path1, (Object)path2);
    }

    public static boolean namesEqual(String name1, String name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return PATH_HASHING_STRATEGY.equals((Object)name1, (Object)name2);
    }

    public static int compareFiles(File file1, File file2) {
        return FileUtil.comparePaths(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static int comparePaths(String path1, String path2) {
        path1 = path1 == null ? null : FileUtil.toSystemIndependentName(path1);
        path2 = path2 == null ? null : FileUtil.toSystemIndependentName(path2);
        return StringUtil.compare(path1, path2, !SystemInfo.isFileSystemCaseSensitive);
    }

    public static int fileHashCode(File file) {
        return FileUtil.pathHashCode(file == null ? null : file.getPath());
    }

    public static int pathHashCode(String path) {
        return StringUtil.isEmpty(path) ? 0 : PATH_HASHING_STRATEGY.computeHashCode((Object)FileUtil.toCanonicalPath(path));
    }

    public static String getExtension(String fileName) {
        return FileUtilRt.getExtension(fileName).toLowerCase();
    }

    public static String resolveShortWindowsName(String path) throws IOException {
        return SystemInfo.isWindows && StringUtil.containsChar(path, '~') ? new File(path).getCanonicalPath() : path;
    }

    public static void collectMatchedFiles(File root, Pattern pattern, List<File> outFiles) {
        FileUtil.collectMatchedFiles(root, root, pattern, outFiles);
    }

    private static void collectMatchedFiles(File absoluteRoot, File root, Pattern pattern, List<File> files) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path;
                String relativePath = FileUtil.getRelativePath(absoluteRoot, dir);
                if (relativePath == null || !pattern.matcher(path = FileUtil.toSystemIndependentName(relativePath)).matches()) continue;
                files.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    @RegExp
    public static String convertAntToRegexp(String antPattern) {
        return FileUtil.convertAntToRegexp(antPattern, true);
    }

    @RegExp
    public static String convertAntToRegexp(String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        StringBuilder builder = new StringBuilder();
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (StringUtil.startsWithChar(antPattern, '/') || StringUtil.startsWithChar(antPattern, '\\')) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        return builder.toString();
    }

    public static boolean moveDirWithContent(File fromDir, File toDir) {
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    public static String sanitizeFileName(String name) {
        return FileUtil.sanitizeFileName(name, true);
    }

    public static String sanitizeName(String name) {
        return FileUtil.sanitizeFileName(name, false);
    }

    private static String sanitizeFileName(String name, boolean strict) {
        StringBuilder result = null;
        int last = 0;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            boolean appendReplacement = true;
            if (c > '\u0000' && c < '\u00ff') {
                if (strict ? Character.isLetterOrDigit(c) || c == '_' : Character.isJavaIdentifierPart(c) || c == ' ' || c == '@' || c == '-') {
                    continue;
                }
            } else {
                appendReplacement = false;
            }
            if (result == null) {
                result = new StringBuilder();
            }
            if (last < i) {
                result.append(name, last, i);
            }
            if (appendReplacement) {
                result.append('_');
            }
            last = i + 1;
        }
        if (result == null) {
            return name;
        }
        if (last < length) {
            result.append(name, last, length);
        }
        return result.toString();
    }

    public static boolean canExecute(File file) {
        return file.canExecute();
    }

    public static void setReadOnlyAttribute(String path, boolean readOnlyFlag) {
        File file = new File(path);
        boolean writableFlag = !readOnlyFlag;
        if (!file.setWritable(writableFlag) && file.canWrite() != writableFlag) {
            LOG.warn("Can't set writable attribute of '" + path + "' to " + readOnlyFlag);
        }
    }

    public static void appendToFile(File file, String text) throws IOException {
        FileUtil.writeToFile(file, text.getBytes(CharsetToolkit.UTF8_CHARSET), true);
    }

    public static void writeToFile(File file, byte[] text) throws IOException {
        FileUtil.writeToFile(file, text, false);
    }

    public static void writeToFile(File file, String text) throws IOException {
        FileUtil.writeToFile(file, text.getBytes(CharsetToolkit.UTF8_CHARSET), false);
    }

    public static void writeToFile(File file, byte[] text, int off, int len) throws IOException {
        FileUtil.writeToFile(file, text, off, len, false);
    }

    public static void writeToFile(File file, byte[] text, boolean append) throws IOException {
        FileUtil.writeToFile(file, text, 0, text.length, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, byte[] text, int off, int len, boolean append) throws IOException {
        FileUtil.createParentDirs(file);
        FileOutputStream stream = new FileOutputStream(file, append);
        try {
            ((OutputStream)stream).write(text, off, len);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static boolean processFilesRecursively(File root, Processor<File> processor) {
        return FileUtil.processFilesRecursively(root, processor, null);
    }

    public static boolean processFilesRecursively(File root, Processor<File> processor, Processor<File> directoryFilter) {
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children;
            File file = (File)queue.removeFirst();
            if (!processor.process(file)) {
                return false;
            }
            if (directoryFilter != null && (!file.isDirectory() || !directoryFilter.process(file)) || (children = file.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children);
        }
        return true;
    }

    public static File findFirstThatExist(String ... paths) {
        for (String path : paths) {
            File file;
            if (StringUtil.isEmptyOrSpaces(path) || !(file = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file;
        }
        return null;
    }

    public static List<File> findFilesByMask(Pattern pattern, File dir) {
        ArrayList<File> found = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    found.addAll(FileUtil.findFilesByMask(pattern, file));
                    continue;
                }
                if (!pattern.matcher(file.getName()).matches()) continue;
                found.add(file);
            }
        }
        return found;
    }

    public static List<File> findFilesOrDirsByMask(Pattern pattern, File dir) {
        ArrayList<File> found = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (pattern.matcher(file.getName()).matches()) {
                    found.add(file);
                }
                if (!file.isDirectory()) continue;
                found.addAll(FileUtil.findFilesOrDirsByMask(pattern, file));
            }
        }
        return found;
    }

    public static String findFileInProvidedPath(String providedPath, String ... fileNames) {
        File file;
        if (StringUtil.isEmpty(providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists()) {
            String name = providedFile.getName();
            for (String fileName : fileNames) {
                if (!name.equals(fileName)) continue;
                return FileUtil.toSystemDependentName(providedFile.getPath());
            }
        }
        if (providedFile.isDirectory()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        if ((providedFile = providedFile.getParentFile()) != null && providedFile.exists()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        return null;
    }

    public static boolean isAbsolutePlatformIndependent(String path) {
        return FileUtil.isUnixAbsolutePath(path) || FileUtil.isWindowsAbsolutePath(path);
    }

    public static boolean isUnixAbsolutePath(String path) {
        return path.startsWith("/");
    }

    public static boolean isWindowsAbsolutePath(String pathString) {
        return pathString.length() >= 2 && Character.isLetter(pathString.charAt(0)) && pathString.charAt(1) == ':';
    }

    public static String getLocationRelativeToUserHome(String path) {
        return FileUtil.getLocationRelativeToUserHome(path, true);
    }

    public static String getLocationRelativeToUserHome(String path, boolean unixOnly) {
        if (path == null) {
            return null;
        }
        if (SystemInfo.isUnix || !unixOnly) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                return '~' + File.separator + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return path;
    }

    public static String expandUserHome(String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        return path;
    }

    public static File[] notNullize(File[] files) {
        return FileUtil.notNullize(files, ArrayUtil.EMPTY_FILE_ARRAY);
    }

    public static File[] notNullize(File[] files, File[] defaultFiles) {
        return files == null ? defaultFiles : files;
    }

    public static boolean isHashBangLine(CharSequence firstCharsIfText, String marker) {
        if (firstCharsIfText == null) {
            return false;
        }
        int lineBreak = StringUtil.indexOf(firstCharsIfText, '\n');
        if (lineBreak < 0) {
            return false;
        }
        String firstLine = ((Object)firstCharsIfText.subSequence(0, lineBreak)).toString();
        if (!firstLine.startsWith("#!")) {
            return false;
        }
        return firstLine.contains(marker);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(prefix, suffix);
    }

    public static File createTempDirectory(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempDirectory(prefix, suffix, deleteOnExit);
    }

    public static File createTempDirectory(File dir, String prefix, String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(dir, prefix, suffix);
    }

    public static File createTempDirectory(File dir, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtilRt.createTempFile(prefix, suffix);
    }

    public static File createTempFile(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempFile(prefix, suffix, deleteOnExit);
    }

    public static File createTempFile(File dir, String prefix, String suffix) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix);
    }

    public static File createTempFile(File dir, String prefix, String suffix, boolean create) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, create);
    }

    public static File createTempFile(File dir, String prefix, String suffix, boolean create, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, create, deleteOnExit);
    }

    public static String getTempDirectory() {
        return FileUtilRt.getTempDirectory();
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        FileUtilRt.resetCanonicalTempPathCache(tempPath);
    }

    public static File generateRandomTemporaryPath() throws IOException {
        return FileUtilRt.generateRandomTemporaryPath();
    }

    public static void setExecutableAttribute(String path, boolean executableFlag) throws IOException {
        FileUtilRt.setExecutableAttribute(path, executableFlag);
    }

    public static void setLastModified(File file, long timeStamp) throws IOException {
        if (!file.setLastModified(timeStamp)) {
            LOG.warn(file.getPath());
        }
    }

    public static String loadFile(File file) throws IOException {
        return FileUtilRt.loadFile(file);
    }

    public static String loadFile(File file, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile(file, convertLineSeparators);
    }

    public static String loadFile(File file, String encoding) throws IOException {
        return FileUtilRt.loadFile(file, encoding);
    }

    public static String loadFile(File file, Charset encoding) throws IOException {
        return String.valueOf(FileUtilRt.loadFileText(file, encoding));
    }

    public static String loadFile(File file, String encoding, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile(file, encoding, convertLineSeparators);
    }

    public static char[] loadFileText(File file) throws IOException {
        return FileUtilRt.loadFileText(file);
    }

    public static char[] loadFileText(File file, String encoding) throws IOException {
        return FileUtilRt.loadFileText(file, encoding);
    }

    public static char[] loadText(Reader reader, int length) throws IOException {
        return FileUtilRt.loadText(reader, length);
    }

    public static List<String> loadLines(File file) throws IOException {
        return FileUtilRt.loadLines(file);
    }

    public static List<String> loadLines(File file, String encoding) throws IOException {
        return FileUtilRt.loadLines(file, encoding);
    }

    public static List<String> loadLines(String path) throws IOException {
        return FileUtilRt.loadLines(path);
    }

    public static List<String> loadLines(String path, String encoding) throws IOException {
        return FileUtilRt.loadLines(path, encoding);
    }

    public static List<String> loadLines(BufferedReader reader) throws IOException {
        return FileUtilRt.loadLines(reader);
    }

    public static List<String> loadLines(InputStream stream) throws IOException {
        return FileUtil.loadLines(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadLines(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            List<String> list = FileUtil.loadLines(bufferedReader);
            return list;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static byte[] loadBytes(InputStream stream) throws IOException {
        return FileUtilRt.loadBytes(stream);
    }

    public static byte[] loadBytes(InputStream stream, int length) throws IOException {
        return FileUtilRt.loadBytes(stream, length);
    }

    public static List<String> splitPath(String path) {
        int nextSeparator;
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((nextSeparator = path.indexOf(File.separatorChar, index)) != -1) {
            list.add(path.substring(index, nextSeparator));
            index = nextSeparator + 1;
        }
        list.add(path.substring(index, path.length()));
        return list;
    }

    public static boolean isJarOrZip(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return StringUtil.endsWithIgnoreCase(name, ".jar") || StringUtil.endsWithIgnoreCase(name, ".zip");
    }

    public static boolean visitFiles(File root, Processor<File> processor) {
        if (!processor.process(root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (FileUtil.visitFiles(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static Map<String, String> loadProperties(Reader reader) throws IOException {
        final LinkedHashMap<String, String> map = ContainerUtil.newLinkedHashMap();
        new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                map.put(String.valueOf(key), String.valueOf(value));
                return super.put(key, value);
            }
        }.load(reader);
        return map;
    }

    public static boolean isRootPath(File file) {
        return FileUtil.isRootPath(file.getPath());
    }

    public static boolean isRootPath(String path) {
        return path.equals("/") || path.matches("[a-zA-Z]:[/\\\\]");
    }

    public static boolean deleteWithRenaming(File file) {
        File tempFileNameForDeletion = FileUtil.findSequentNonexistentFile(file.getParentFile(), file.getName(), "");
        boolean success = file.renameTo(tempFileNameForDeletion);
        return FileUtil.delete(success ? tempFileNameForDeletion : file);
    }

    public static boolean isFileSystemCaseSensitive(String path) throws FileNotFoundException {
        FileAttributes attributes = FileSystemUtil.getAttributes(path);
        if (attributes == null) {
            throw new FileNotFoundException(path);
        }
        FileAttributes upper = FileSystemUtil.getAttributes(path.toUpperCase(Locale.ENGLISH));
        FileAttributes lower = FileSystemUtil.getAttributes(path.toLowerCase(Locale.ENGLISH));
        return !attributes.equals(upper) || !attributes.equals(lower);
    }
}

