/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

public class Version {
    public final int major;
    public final int minor;
    public final int bugfix;

    public Version(int major, int minor, int bugfix) {
        this.bugfix = bugfix;
        this.minor = minor;
        this.major = major;
    }

    public boolean is(Integer major) {
        return this.is(major, null);
    }

    public boolean is(Integer major, Integer minor) {
        return this.is(major, minor, null);
    }

    public boolean is(Integer major, Integer minor, Integer bugfix) {
        return this.compareTo(major, minor, bugfix) == 0;
    }

    public boolean isOrGreaterThan(Integer major) {
        return this.isOrGreaterThan(major, null);
    }

    public boolean isOrGreaterThan(Integer major, Integer minor) {
        return this.isOrGreaterThan(major, minor, null);
    }

    public boolean isOrGreaterThan(Integer major, Integer minor, Integer bugfix) {
        return this.compareTo(major, minor, bugfix) >= 0;
    }

    public boolean lessThan(Integer major) {
        return this.lessThan(major, null);
    }

    public boolean lessThan(Integer major, Integer minor) {
        return this.lessThan(major, minor, null);
    }

    public boolean lessThan(Integer major, Integer minor, Integer bugfix) {
        return this.compareTo(major, minor, bugfix) < 0;
    }

    public int compareTo(Version version) {
        return this.compareTo(version.major, version.minor, version.bugfix);
    }

    public int compareTo(Integer major) {
        return this.compareTo(major, null);
    }

    public int compareTo(Integer major, Integer minor) {
        return this.compareTo(major, minor, null);
    }

    public int compareTo(Integer major, Integer minor, Integer bugfix) {
        int result = Version.doCompare(this.major, major);
        if (result != 0) {
            return result;
        }
        result = Version.doCompare(this.minor, minor);
        if (result != 0) {
            return result;
        }
        return Version.doCompare(this.bugfix, bugfix);
    }

    private static int doCompare(Integer l, Integer r) {
        if (l == null || r == null) {
            return 0;
        }
        return l - r;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    public String toCompactString() {
        return Version.toCompactString(this.major, this.minor, this.bugfix);
    }

    public static String toCompactString(int major, int minor, int bugfix) {
        String res = major + "." + minor;
        if (bugfix > 0) {
            res = res + "." + bugfix;
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.bugfix != version.bugfix) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        return this.minor == version.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.bugfix;
        return result;
    }
}

