/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ShutDownTracker
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ShutDownTracker");
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Thread> myShutdownThreads = new LinkedList();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private volatile boolean myIsShutdownHookRunning = false;

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "Shutdown tracker"));
    }

    public static ShutDownTracker getInstance() {
        return ShutDownTrackerHolder.ourInstance;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myIsShutdownHookRunning;
    }

    @Override
    public void run() {
        this.myIsShutdownHookRunning = true;
        this.ensureStopperThreadsFinished();
        Runnable task = this.removeLast(this.myShutdownTasks);
        while (task != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            task = this.removeLast(this.myShutdownTasks);
        }
        Thread thread = this.removeLast(this.myShutdownThreads);
        while (thread != null) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread = this.removeLast(this.myShutdownThreads);
        }
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    LOG.error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(Thread thread) {
        return this.myThreads.contains(thread);
    }

    private synchronized Thread[] getStopperThreads() {
        return this.myThreads.toArray(new Thread[this.myThreads.size()]);
    }

    public synchronized void registerStopperThread(Thread thread) {
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(Thread thread) {
        this.myThreads.remove(thread);
    }

    public synchronized void registerShutdownThread(Thread thread) {
        this.myShutdownThreads.addLast(thread);
    }

    public synchronized void registerShutdownThread(int index, Thread thread) {
        this.myShutdownThreads.add(index, thread);
    }

    public synchronized void registerShutdownTask(Runnable task) {
        this.myShutdownTasks.addLast(task);
    }

    public synchronized void unregisterShutdownTask(Runnable task) {
        this.myShutdownTasks.remove(task);
    }

    private synchronized <T> T removeLast(LinkedList<T> list) {
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    public static void invokeAndWait(boolean returnOnTimeout, boolean runInEdt, final Runnable runnable) {
        if (!runInEdt) {
            if (returnOnTimeout) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        semaphore.up();
                    }
                }).start();
                semaphore.waitFor(1000L);
            } else {
                runnable.run();
            }
            return;
        }
        if (returnOnTimeout) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.up();
                }
            });
            semaphore.waitFor(1000L);
            return;
        }
        try {
            UIUtil.invokeAndWaitIfNeeded(runnable);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

