/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;

public class JDOMExternalizerUtil {
    private static final String VALUE_ATTR_NAME = "value";

    public static void writeField(Element root, String fieldName, String value) {
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        element.setAttribute(VALUE_ATTR_NAME, value == null ? "" : value);
        root.addContent(element);
    }

    public static String readField(Element parent, String fieldName, String defaultValue) {
        String val = JDOMExternalizerUtil.readField(parent, fieldName);
        return val == null ? defaultValue : val;
    }

    public static String readField(Element parent, String fieldName) {
        for (Element element : JDOMUtil.getChildren(parent, "option")) {
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element.getAttributeValue(VALUE_ATTR_NAME);
        }
        return null;
    }

    public static Element getOption(Element parent, String fieldName) {
        for (Element element : JDOMUtil.getChildren(parent, "option")) {
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element;
        }
        return null;
    }

    public static Element writeOption(Element root, String fieldName) {
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        root.addContent(element);
        return element;
    }

    public static Element addElementWithValueAttribute(Element parent, String childTagName, String attrValue) {
        Element element = new Element(childTagName);
        if (attrValue != null) {
            element.setAttribute(VALUE_ATTR_NAME, attrValue);
        }
        parent.addContent(element);
        return element;
    }

    public static String getFirstChildValueAttribute(Element parent, String childTagName) {
        Element first;
        List children = parent.getChildren(childTagName);
        if (!children.isEmpty() && (first = (Element)children.get(0)) != null) {
            return first.getAttributeValue(VALUE_ATTR_NAME);
        }
        return null;
    }

    public static List<String> getChildrenValueAttributes(Element parent, String childTagName) {
        List children = parent.getChildren(childTagName);
        if (children.isEmpty()) {
            return Collections.emptyList();
        }
        if (children.size() == 1) {
            String value = ((Element)children.iterator().next()).getAttributeValue(VALUE_ATTR_NAME);
            return value == null ? Collections.emptyList() : Collections.singletonList(value);
        }
        ArrayList<String> values = ContainerUtil.newArrayListWithCapacity(children.size());
        for (Element child : children) {
            String value = child.getAttributeValue(VALUE_ATTR_NAME);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static void addChildrenWithValueAttribute(Element parent, String childTagName, List<String> attrValues) {
        for (String value : attrValues) {
            if (value == null) continue;
            Element child = new Element(childTagName);
            child.setAttribute(VALUE_ATTR_NAME, value);
            parent.addContent(child);
        }
    }

    public static void addChildren(Element parent, String childElementName, Collection<? extends JDOMExternalizable> children) throws WriteExternalException {
        for (JDOMExternalizable jDOMExternalizable : children) {
            if (jDOMExternalizable == null) continue;
            Element element = new Element(childElementName);
            jDOMExternalizable.writeExternal(element);
            parent.addContent(element);
        }
    }
}

