/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.LineBlockDivider;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.ByWord;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffFragmentsProcessor;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.processing.DummyDiffFragmentsProcessor;
import com.intellij.openapi.diff.impl.processing.FragmentsCollector;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.diff.impl.processing.LineFragmentsCollector;
import com.intellij.openapi.diff.impl.processing.PreferWholeLines;
import com.intellij.openapi.diff.impl.processing.UniteSameType;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextCompareProcessor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.Processor");
    private final ComparisonPolicy myComparisonPolicy;
    private final DiffPolicy myDiffPolicy;
    private final HighlightMode myHighlightMode;

    public TextCompareProcessor(ComparisonPolicy comparisonPolicy, DiffPolicy diffPolicy, HighlightMode highlightMode) {
        this.myComparisonPolicy = comparisonPolicy;
        this.myDiffPolicy = diffPolicy;
        this.myHighlightMode = highlightMode;
    }

    public TextCompareProcessor(ComparisonPolicy comparisonPolicy) {
        this(comparisonPolicy, DiffPolicy.LINES_WO_FORMATTING, HighlightMode.BY_WORD);
    }

    public List<LineFragment> process(String text1, String text2) throws FilesTooBigForDiffException {
        if (this.myHighlightMode == HighlightMode.NO_HIGHLIGHTING) {
            return Collections.emptyList();
        }
        text1 = StringUtil.notNullize(text1);
        text2 = StringUtil.notNullize(text2);
        if (text1.isEmpty() || text2.isEmpty()) {
            return new DummyDiffFragmentsProcessor().process(text1, text2);
        }
        DiffString diffText1 = DiffString.create(text1);
        DiffString diffText2 = DiffString.create(text2);
        DiffFragment[] woFormattingBlocks = this.myDiffPolicy.buildFragments(diffText1, diffText2);
        DiffFragment[] step1lineFragments = new DiffCorrection.TrueLineBlocks(this.myComparisonPolicy).correctAndNormalize(woFormattingBlocks);
        ArrayList<LineFragment> lineBlocks = new DiffFragmentsProcessor().process(step1lineFragments);
        int badLinesCount = 0;
        if (this.myHighlightMode == HighlightMode.BY_WORD) {
            for (LineFragment lineBlock : lineBlocks) {
                if (lineBlock.isOneSide() || lineBlock.isEqual()) continue;
                try {
                    DiffString subText1 = lineBlock.getText(diffText1, FragmentSide.SIDE1);
                    DiffString subText2 = lineBlock.getText(diffText2, FragmentSide.SIDE2);
                    ArrayList<LineFragment> subFragments = this.findSubFragments(subText1, subText2);
                    lineBlock.setChildren(new ArrayList<Fragment>(subFragments));
                    lineBlock.adjustTypeFromChildrenTypes();
                }
                catch (FilesTooBigForDiffException ignore) {
                    if (++badLinesCount <= FilesTooBigForDiffException.MAX_BAD_LINES) continue;
                    break;
                }
            }
        }
        return lineBlocks;
    }

    private ArrayList<LineFragment> findSubFragments(DiffString text1, DiffString text2) throws FilesTooBigForDiffException {
        DiffFragment[] fragments = new ByWord(this.myComparisonPolicy).buildFragments(text1, text2);
        fragments = DiffCorrection.ConnectSingleSideToChange.INSTANCE.correct(fragments);
        fragments = UniteSameType.INSTANCE.correct(fragments);
        fragments = PreferWholeLines.INSTANCE.correct(fragments);
        fragments = UniteSameType.INSTANCE.correct(fragments);
        DiffFragment[][] lines = Util.splitByUnchangedLines(fragments);
        lines = Util.uniteFormattingOnly(lines);
        LineFragmentsCollector collector = new LineFragmentsCollector();
        for (DiffFragment[] line : lines) {
            DiffFragment[][] subLines = LineBlockDivider.SINGLE_SIDE.divide(line);
            for (DiffFragment[] subLineFragments : subLines = Util.uniteFormattingOnly(subLines)) {
                LineFragment subLine = collector.addDiffFragment(Util.concatenate(subLineFragments));
                if (subLine.isOneSide()) continue;
                subLine.setChildren(TextCompareProcessor.processInlineFragments(subLineFragments));
            }
        }
        return collector.getFragments();
    }

    private static ArrayList<Fragment> processInlineFragments(DiffFragment[] subLineFragments) {
        LOG.assertTrue(subLineFragments.length > 0);
        FragmentsCollector result = new FragmentsCollector();
        for (DiffFragment fragment : subLineFragments) {
            result.addDiffFragment(fragment);
        }
        return result.getFragments();
    }
}

