/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.string.DiffString;

public enum FragmentSide {
    SIDE1(0, 0){

        @Override
        public DiffString getText(DiffFragment fragment) {
            return fragment.getText1();
        }

        @Override
        protected DiffFragment createDiffFragment(DiffString text, DiffString otherText) {
            return new DiffFragment(text, otherText);
        }

        @Override
        public FragmentSide otherSide() {
            return SIDE2;
        }
    }
    ,
    SIDE2(1, 2){

        @Override
        public DiffString getText(DiffFragment fragment) {
            return fragment.getText2();
        }

        @Override
        protected DiffFragment createDiffFragment(DiffString text, DiffString otherText) {
            return new DiffFragment(otherText, text);
        }

        @Override
        public FragmentSide otherSide() {
            return SIDE1;
        }
    };

    private static final Logger LOG;
    private final int myIndex;
    private final int myMergeIndex;

    private FragmentSide(int index, int mergeIndex) {
        this.myIndex = index;
        this.myMergeIndex = mergeIndex;
    }

    public DiffFragment createFragment(DiffString text, DiffString otherText, boolean modified) {
        DiffFragment fragment = this.createDiffFragment(text, otherText);
        if (!fragment.isOneSide()) {
            fragment.setModified(modified);
        }
        return fragment;
    }

    public abstract DiffString getText(DiffFragment var1);

    public abstract FragmentSide otherSide();

    protected abstract DiffFragment createDiffFragment(DiffString var1, DiffString var2);

    public int getIndex() {
        return this.myIndex;
    }

    public int getMergeIndex() {
        return this.myMergeIndex;
    }

    public DiffString getOtherText(DiffFragment fragment) {
        return this.otherSide().getText(fragment);
    }

    public IllegalArgumentException invalidException() {
        return new IllegalArgumentException(String.valueOf((Object)this));
    }

    public static FragmentSide chooseSide(DiffFragment oneSide) {
        LOG.assertTrue(oneSide.isOneSide());
        return oneSide.getText1() == null ? SIDE2 : SIDE1;
    }

    public static FragmentSide fromIndex(int index) {
        for (FragmentSide side : FragmentSide.values()) {
            if (side.getIndex() != index) continue;
            return side;
        }
        throw new IllegalArgumentException(String.valueOf(index));
    }

    static {
        LOG = Logger.getInstance(FragmentSide.class);
    }
}

