/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import java.util.List;

public abstract class LineTokenizerBase<T> {
    private int myIndex = 0;
    private int myLineSeparatorStart = -1;
    private int myLineSeparatorEnd = -1;

    protected abstract void addLine(List<T> var1, int var2, int var3, boolean var4);

    protected abstract char charAt(int var1);

    protected abstract int length();

    protected abstract String substring(int var1, int var2);

    public void doExecute(List<T> lines) {
        while (this.notAtEnd()) {
            int begin = this.myIndex;
            this.skipToEOL();
            int endIndex = this.myIndex;
            boolean appendNewLine = false;
            if (this.notAtEnd() && this.isAtEOL()) {
                if (this.charAt(endIndex) == '\n') {
                    ++endIndex;
                } else {
                    appendNewLine = true;
                }
                this.skipEOL();
            }
            this.addLine(lines, begin, endIndex, appendNewLine);
        }
    }

    private void skipEOL() {
        int eolStart = this.myIndex;
        boolean nFound = false;
        boolean rFound = false;
        while (this.notAtEnd()) {
            boolean r;
            boolean n = this.charAt(this.myIndex) == '\n';
            boolean bl = r = this.charAt(this.myIndex) == '\r';
            if (!n && !r || nFound && n || rFound && r) break;
            nFound |= n;
            rFound |= r;
            ++this.myIndex;
        }
        if (this.myLineSeparatorStart == -1) {
            this.myLineSeparatorStart = eolStart;
            this.myLineSeparatorEnd = this.myIndex;
        }
    }

    public String getLineSeparator() {
        if (this.myLineSeparatorStart == -1) {
            return null;
        }
        return this.substring(this.myLineSeparatorStart, this.myLineSeparatorEnd);
    }

    private void skipToEOL() {
        while (this.notAtEnd() && !this.isAtEOL()) {
            ++this.myIndex;
        }
    }

    private boolean notAtEnd() {
        return this.myIndex < this.length();
    }

    private boolean isAtEOL() {
        return this.charAt(this.myIndex) == '\r' || this.charAt(this.myIndex) == '\n';
    }
}

