/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import java.lang.reflect.Constructor;
import org.apache.log4j.Level;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();

    public static void setFactory(Class<? extends Factory> factory) {
        if (Logger.isInitialized()) {
            if (factory.isInstance(ourFactory)) {
                return;
            }
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        try {
            Constructor<? extends Factory> constructor = factory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    public static Logger getInstance(String category) {
        return ourFactory.getLoggerInstance(category);
    }

    public static Logger getInstance(Class cl) {
        return Logger.getInstance("#" + cl.getName());
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(String var1);

    public abstract void debug(Throwable var1);

    public abstract void debug(String var1, Throwable var2);

    public void debug(String message, Object ... details) {
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(String.valueOf(detail));
            }
            this.debug(sb.toString());
        }
    }

    public void info(Throwable t) {
        this.info(t.getMessage(), t);
    }

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(Throwable t) {
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(String var1, Throwable var2);

    public void error(String message) {
        this.error(message, new EmptyThrowable(), ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(String message, Attachment ... attachments) {
        this.error(message);
    }

    public void error(String message, String ... details) {
        this.error(message, new EmptyThrowable(), details);
    }

    public void error(String message, Throwable e) {
        this.error(message, e, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Throwable t) {
        this.error(t.getMessage(), t, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public abstract void error(String var1, Throwable var2, String ... var3);

    public boolean assertTrue(boolean value, Object message) {
        if (!value) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable());
        }
        return value;
    }

    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    public abstract void setLevel(Level var1);

    public static class EmptyThrowable
    extends Throwable {
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        public Logger getLoggerInstance(String category) {
            return new DefaultLogger(category);
        }
    }

    public static interface Factory {
        public Logger getLoggerInstance(String var1);
    }
}

