/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.lang.ref.Reference;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AbstractBundle {
    private static final Logger LOG = Logger.getInstance("#com.intellij.AbstractBundle");
    private Reference<ResourceBundle> myBundle;
    private final String myPathToBundle;
    private static final FactoryMap<ClassLoader, Map<String, ResourceBundle>> ourCache = new ConcurrentWeakFactoryMap<ClassLoader, Map<String, ResourceBundle>>(){

        @Override
        protected Map<String, ResourceBundle> create(ClassLoader key) {
            return ContainerUtil.createConcurrentSoftValueMap();
        }
    };

    protected AbstractBundle(String pathToBundle) {
        this.myPathToBundle = pathToBundle;
    }

    public String getMessage(String key, Object ... params) {
        return CommonBundle.message(this.getBundle(), key, params);
    }

    private ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(this.myBundle);
        if (bundle == null) {
            bundle = AbstractBundle.getResourceBundle(this.myPathToBundle, this.getClass().getClassLoader());
            this.myBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static ResourceBundle getResourceBundle(String pathToBundle, ClassLoader loader) {
        Map<String, ResourceBundle> map = ourCache.get(loader);
        ResourceBundle result = map.get(pathToBundle);
        if (result == null) {
            try {
                ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
                result = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                ResourceBundle.clearCache(loader);
                result = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            }
            map.put(pathToBundle, result);
        }
        return result;
    }
}

