/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    public static final String ATTRIBUTE_AREA = "area";
    private static final Map<String, String> ourDefaultEPs = new THashMap();
    private static final boolean DEBUG_REGISTRATION = false;
    private final AreaPicoContainer myPicoContainer;
    private final Throwable myCreationTrace = null;
    private final Map<String, ExtensionPointImpl> myExtensionPoints = ContainerUtil.newConcurrentMap();
    private final Map<String, Throwable> myEPTraces = null;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners = MultiMap.createSmart();
    private final List<Runnable> mySuspendedListenerActions = new ArrayList<Runnable>();
    private boolean myAvailabilityNotificationsActive = true;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, LogProvider logger) {
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.myLogger = logger;
        this.initialize();
    }

    ExtensionsAreaImpl(MutablePicoContainer parentPicoContainer, LogProvider logger) {
        this(null, null, (PicoContainer)parentPicoContainer, logger);
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    public AreaPicoContainer getPicoContainer() {
        return this.myPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(String pluginName, Element extensionPointElement) {
        this.registerExtensionPoint(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionPointElement);
    }

    @Override
    public void registerExtensionPoint(PluginDescriptor pluginDescriptor, Element extensionPointElement) {
        ExtensionPoint.Kind kind;
        String className;
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String epName = extensionPointElement.getAttributeValue("qualifiedName");
        if (epName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            epName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (interfaceClassName != null) {
            className = interfaceClassName;
            kind = ExtensionPoint.Kind.INTERFACE;
        } else {
            className = beanClassName;
            kind = ExtensionPoint.Kind.BEAN_CLASS;
        }
        this.registerExtensionPoint(epName, className, pluginDescriptor, kind);
    }

    @Override
    public void registerExtension(String pluginName, Element extensionElement) {
        this.registerExtension(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionElement);
    }

    @Override
    public void registerExtension(PluginDescriptor pluginDescriptor, Element extensionElement) {
        ExtensionComponentAdapter adapter;
        PluginId pluginId = pluginDescriptor.getPluginId();
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        ExtensionPoint extensionPoint = this.getExtensionPoint(epName);
        if (((ExtensionPointImpl)extensionPoint).getKind() == ExtensionPoint.Kind.INTERFACE) {
            String implClass = extensionElement.getAttributeValue("implementation");
            if (implClass == null) {
                throw new RuntimeException("'implementation' attribute not specified for '" + epName + "' extension in '" + pluginId.getIdString() + "' plugin");
            }
            adapter = new ExtensionComponentAdapter(implClass, extensionElement, (PicoContainer)this.myPicoContainer, pluginDescriptor, ExtensionsAreaImpl.shouldDeserializeInstance(extensionElement));
        } else {
            adapter = new ExtensionComponentAdapter(((ExtensionPointImpl)extensionPoint).getClassName(), extensionElement, (PicoContainer)this.myPicoContainer, pluginDescriptor, true);
        }
        this.myPicoContainer.registerComponent((ComponentAdapter)adapter);
        ((ExtensionPointImpl)extensionPoint).registerExtensionAdapter(adapter);
    }

    private static boolean shouldDeserializeInstance(Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String extractEPName(Element extensionElement) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            String ns;
            Element parentElement = extensionElement.getParentElement();
            String string = ns = parentElement != null ? parentElement.getAttributeValue("defaultExtensionNs") : null;
            if (ns != null) {
                epName = ns + '.' + extensionElement.getName();
            } else {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    @Override
    public PicoContainer getPluginContainer(String pluginName) {
        return this.internalGetPluginContainer();
    }

    private MutablePicoContainer internalGetPluginContainer() {
        return this.myPicoContainer;
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(Object extension, PluginDescriptor pluginDescriptor) {
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get((Object)epListenerExtension.getExtensionPointName());
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(Object extension, PluginDescriptor pluginDescriptor) {
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object instantiate(Class clazz) {
        ConstructorInjectionComponentAdapter adapter = new ConstructorInjectionComponentAdapter((Object)Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance((PicoContainer)this.getPicoContainer());
    }

    public Throwable getCreationTrace() {
        return this.myCreationTrace;
    }

    @Override
    public void addAvailabilityListener(String extensionPointName, ExtensionPointAvailabilityListener listener) {
        this.myAvailabilityListeners.putValue((Object)extensionPointName, (Object)listener);
        if (this.hasExtensionPoint(extensionPointName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(extensionPointName));
        }
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, ExtensionPoint.Kind.INTERFACE);
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass, ExtensionPoint.Kind kind) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor(), kind);
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass, PluginDescriptor descriptor) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, descriptor, ExtensionPoint.Kind.INTERFACE);
    }

    private void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass, PluginDescriptor descriptor, ExtensionPoint.Kind kind) {
        if (this.hasExtensionPoint(extensionPointName)) {
            throw new RuntimeException("Duplicate registration for EP: " + extensionPointName);
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, kind, this, this.myAreaInstance, this.myLogger, descriptor));
    }

    public void registerExtensionPoint(ExtensionPointImpl extensionPoint) {
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection listeners = this.myAvailabilityListeners.get((Object)extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(final ExtensionPointAvailabilityListener listener, final ExtensionPoint extensionPoint) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRegistered(extensionPoint);
            }
        });
    }

    private void queueNotificationAction(Runnable action) {
        if (this.myAvailabilityNotificationsActive) {
            action.run();
        } else {
            this.mySuspendedListenerActions.add(action);
        }
    }

    public <T> ExtensionPointImpl<T> getExtensionPoint(String extensionPointName) {
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        return extensionPoint;
    }

    @Override
    public <T> ExtensionPoint<T> getExtensionPoint(ExtensionPointName<T> extensionPointName) {
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.myExtensionPoints.values().toArray(new ExtensionPoint[this.myExtensionPoints.size()]);
    }

    @Override
    public void unregisterExtensionPoint(String extensionPointName) {
        ExtensionPoint extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint != null) {
            extensionPoint.reset();
            this.myExtensionPoints.remove(extensionPointName);
            this.notifyEPRemoved(extensionPoint);
        }
    }

    private void notifyEPRemoved(ExtensionPoint extensionPoint) {
        Collection listeners = this.myAvailabilityListeners.get((Object)extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyUnavailableListener(extensionPoint, listener);
        }
    }

    private void notifyUnavailableListener(final ExtensionPoint extensionPoint, final ExtensionPointAvailabilityListener listener) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRemoved(extensionPoint);
            }
        });
    }

    @Override
    public boolean hasExtensionPoint(String extensionPointName) {
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public void suspendInteractions() {
        this.myAvailabilityNotificationsActive = false;
    }

    @Override
    public void resumeInteractions() {
        ExtensionPoint[] extensionPoints;
        this.myAvailabilityNotificationsActive = true;
        for (ExtensionPoint extensionPoint : extensionPoints = this.getExtensionPoints()) {
            extensionPoint.getExtensions();
        }
        for (Runnable action : this.mySuspendedListenerActions) {
            try {
                action.run();
            }
            catch (Exception e) {
                this.myLogger.error(e);
            }
        }
        this.mySuspendedListenerActions.clear();
    }

    @Override
    public void killPendingInteractions() {
        this.mySuspendedListenerActions.clear();
    }

    public void removeAllComponents(Set<ExtensionComponentAdapter> extensionAdapters) {
        Iterator<ExtensionComponentAdapter> i$ = extensionAdapters.iterator();
        while (i$.hasNext()) {
            ExtensionComponentAdapter extensionAdapter;
            ExtensionComponentAdapter componentAdapter = extensionAdapter = i$.next();
            this.internalGetPluginContainer().unregisterComponent(componentAdapter.getComponentKey());
        }
    }

    static {
        ourDefaultEPs.put("com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
    }
}

