/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SmartExtensionPoint<Extension, V>
implements ExtensionPointAndAreaListener<Extension> {
    private final Collection<V> myExplicitExtensions;
    private ExtensionPoint<Extension> myExtensionPoint;
    private List<V> myCache;

    protected SmartExtensionPoint(Collection<V> explicitExtensions) {
        this.myExplicitExtensions = explicitExtensions;
    }

    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(V extension) {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(V extension) {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    protected abstract V getExtension(Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<V> getExtensions() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache == null) {
                this.myExtensionPoint = this.getExtensionPoint();
                this.myExtensionPoint.addExtensionPointListener(this);
                this.myCache = new ArrayList<V>(this.myExplicitExtensions);
                this.myCache.addAll(ContainerUtil.mapNotNull((Object[])this.myExtensionPoint.getExtensions(), (Function)new NullableFunction<Extension, V>(){

                    public V fun(Extension extension) {
                        return SmartExtensionPoint.this.getExtension(extension);
                    }
                }));
            }
            return this.myCache;
        }
    }

    @Override
    public final void extensionAdded(Extension extension, PluginDescriptor pluginDescriptor) {
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache != null) {
                this.myCache = null;
                this.myExtensionPoint.removeExtensionPointListener(this);
                this.myExtensionPoint = null;
            }
        }
    }

    @Override
    public final void extensionRemoved(Extension extension, PluginDescriptor pluginDescriptor) {
        this.dropCache();
    }

    @Override
    public void areaReplaced(ExtensionsArea area) {
        this.dropCache();
    }
}

