/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import gnu.trove.THashMap;
import java.util.Map;

public class PluginId
implements Comparable<PluginId> {
    public static final PluginId[] EMPTY_ARRAY = new PluginId[0];
    private static final Map<String, PluginId> ourRegisteredIds = new THashMap();
    private final String myIdString;

    private PluginId(String idString) {
        this.myIdString = idString;
    }

    @Override
    public int compareTo(PluginId o) {
        return this.myIdString.compareTo(o.myIdString);
    }

    public static synchronized PluginId getId(String idString) {
        PluginId pluginId = ourRegisteredIds.get(idString);
        if (pluginId == null) {
            pluginId = new PluginId(idString);
            ourRegisteredIds.put(idString, pluginId);
        }
        return pluginId;
    }

    public static synchronized PluginId findId(String ... idStrings) {
        for (String idString : idStrings) {
            PluginId pluginId = ourRegisteredIds.get(idString);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    public String getIdString() {
        return this.myIdString;
    }

    public String toString() {
        return this.getIdString();
    }

    public static synchronized Map<String, PluginId> getRegisteredIds() {
        return new THashMap(ourRegisteredIds);
    }
}

