/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.util;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.javacvsImpl.FileReadOnlyHandler;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CvsFileUtil {
    private CvsFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLinesFrom(File file) throws IOException {
        FileUtil.createIfDoesntExist((File)file);
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CvsApplicationLevelConfiguration.getCharset()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLinesFrom(File file, String cvsRootToSkip) throws IOException {
        FileUtil.createIfDoesntExist((File)file);
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CvsApplicationLevelConfiguration.getCharset()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains(cvsRootToSkip)) continue;
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    private static String getLineSeparatorFor(File file) {
        VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(file);
        if (virtualFile != null) {
            return FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        }
        return CodeStyleSettingsManager.getInstance().getCurrentSettings().getLineSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeLines(List<String> lines, File file) throws IOException {
        String separator = CvsFileUtil.getLineSeparatorFor(file);
        FileUtil.createIfDoesntExist((File)file);
        if (!file.canWrite()) {
            new FileReadOnlyHandler().setFileReadOnly(file, false);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), CvsApplicationLevelConfiguration.getCharset());
        try {
            for (String line : lines) {
                writer.write(line);
                writer.write(separator);
            }
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static void appendLineToFile(String line, File file) throws IOException {
        FileUtil.createIfDoesntExist((File)file);
        List<String> lines = CvsFileUtil.readLinesFrom(file);
        lines.add(line);
        CvsFileUtil.storeLines(lines, file);
    }
}

