/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ImportConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportDetails;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.SelectCVSConfigurationStep;
import com.intellij.cvsSupport2.ui.experts.SelectCvsElementStep;
import com.intellij.cvsSupport2.ui.experts.importToCvs.ImportSettingsStep;
import com.intellij.cvsSupport2.ui.experts.importToCvs.SelectImportLocationStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class ImportWizard
extends CvsWizard {
    private final SelectCVSConfigurationStep mySelectCVSConfigurationStep;
    private final SelectCvsElementStep mySelectCvsElementStep;
    private final SelectImportLocationStep mySelectImportLocationStep;
    private final ImportSettingsStep mySettingsStep;

    public ImportWizard(Project project, VirtualFile selectedFile) {
        super(CvsBundle.message((String)"dialog.title.import.into.cvs", (Object[])new Object[0]), project);
        ImportConfiguration importConfig = ImportConfiguration.getInstance();
        this.mySelectCVSConfigurationStep = new SelectCVSConfigurationStep(project, (CvsWizard)this);
        this.mySelectCvsElementStep = new SelectCvsElementStep(CvsBundle.message((String)"dialog.title.select.directory.to.import.into", (Object[])new Object[0]), this, project, this.mySelectCVSConfigurationStep, true, 1, false, false);
        this.mySelectImportLocationStep = new SelectImportLocationStep(CvsBundle.message((String)"dialog.title.select.import.directory", (Object[])new Object[0]), (CvsWizard)this, project, selectedFile);
        this.mySettingsStep = new ImportSettingsStep(project, this, this.mySelectImportLocationStep, importConfig);
        this.addStep((Step)this.mySelectCVSConfigurationStep);
        this.addStep((Step)this.mySelectCvsElementStep);
        this.addStep((Step)this.mySelectImportLocationStep);
        this.addStep((Step)this.mySettingsStep);
        this.init();
    }

    public ImportDetails createImportDetails() {
        CvsElement module = this.mySelectCvsElementStep.getSelectedCvsElement();
        String moduleName = this.mySettingsStep.getModuleName();
        String importModuleName = module.getElementPath().equals(".") ? moduleName : module.getElementPath() + "/" + moduleName;
        File selectedFile = this.mySelectImportLocationStep.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        return new ImportDetails(selectedFile, this.mySettingsStep.getVendor(), this.mySettingsStep.getReleaseTag(), this.mySettingsStep.getLogMessage(), importModuleName, this.mySelectCVSConfigurationStep.getSelectedConfiguration(), this.mySettingsStep.getFileExtensions(), this.mySelectImportLocationStep.getIgnoreFileFilter());
    }

    @Override
    protected String getHelpID() {
        return "cvs.import";
    }
}

