/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsRootException;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsTree;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.SelectCVSConfigurationStep;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;

public class SelectCvsElementStep
extends WizardStep {
    private CvsTree myCvsTree;
    private final SelectCVSConfigurationStep mySelectCVSConfigurationStep;
    private final Project myProject;
    private final boolean myShowFiles;
    @JdkConstants.TreeSelectionMode
    private final int mySelectionMode;
    private final boolean myAllowRootSelection;
    private final boolean myShowModules;
    private final Ref<Boolean> myErrors = new Ref();

    public SelectCvsElementStep(String title, CvsWizard wizard, Project project, SelectCVSConfigurationStep selectCVSConfigurationStep, boolean allowRootSelection, @JdkConstants.TreeSelectionMode int selectionMode, boolean showModules, boolean showFiles) {
        super(title, wizard);
        this.myShowModules = showModules;
        this.mySelectCVSConfigurationStep = selectCVSConfigurationStep;
        this.myProject = project;
        this.myShowFiles = showFiles;
        this.mySelectionMode = selectionMode;
        this.myAllowRootSelection = allowRootSelection;
        this.init();
    }

    @Override
    public boolean nextIsEnabled() {
        return this.myCvsTree.getCurrentSelection().length > 0 && this.myErrors.isNull();
    }

    private boolean isLogged(CvsRootConfiguration selectedConfiguration) {
        this.myErrors.set(null);
        LoginPerformer performer = new LoginPerformer(this.myProject, Collections.singletonList(selectedConfiguration), new Consumer<VcsException>(){

            public void consume(VcsException e) {
                SelectCvsElementStep.this.myErrors.set((Object)Boolean.TRUE);
            }
        });
        try {
            boolean logged = performer.loginAll(false);
            return logged && this.myErrors.isNull();
        }
        catch (CvsRootException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)CvsBundle.message((String)"error.title.invalid.cvs.root", (Object[])new Object[0]));
            return false;
        }
    }

    @Override
    public boolean preNextCheck() {
        CvsRootConfiguration selectedConfiguration = this.mySelectCVSConfigurationStep.getSelectedConfiguration();
        if (selectedConfiguration == null) {
            return false;
        }
        boolean logged = this.isLogged(selectedConfiguration);
        if (logged) {
            this.myCvsTree.setCvsRootConfiguration(selectedConfiguration.clone());
        }
        return logged;
    }

    @Override
    protected void dispose() {
        if (this.myCvsTree != null) {
            this.myCvsTree.deactivated();
        }
    }

    public CvsElement getSelectedCvsElement() {
        CvsElement[] selection = this.myCvsTree.getCurrentSelection();
        if (selection.length == 0) {
            return null;
        }
        return selection[0];
    }

    @Override
    protected JComponent createComponent() {
        this.myCvsTree = new CvsTree(this.myProject, this.myAllowRootSelection, this.mySelectionMode, this.myShowModules, this.myShowFiles, new Consumer<VcsException>(){

            public void consume(final VcsException e) {
                SelectCvsElementStep.this.myErrors.set((Object)Boolean.TRUE);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)e.getMessage(), (String)CvsBundle.message((String)"error.title.cvs.error", (Object[])new Object[0]));
                    }
                }, ModalityState.any());
            }
        });
        this.myCvsTree.init();
        this.myCvsTree.addSelectionObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if ("Selection Changed".equals(arg)) {
                    SelectCvsElementStep.this.getWizard().updateStep();
                }
            }
        });
        return this.myCvsTree;
    }

    public CvsElement[] getSelectedCvsElements() {
        return this.myCvsTree.getCurrentSelection();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myCvsTree.getTree();
    }
}

