/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class StreamLogger
implements IStreamLogger {
    private int myCloseCount = 0;
    private static final OutputStream DUMMY_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) {
        }
    };
    private OutputStream myLogOutput;
    private static final long MAX_OUTPUT_SIZE = 1000000L;
    private static final String OUTPUT_FILE_NAME = "cvs.log";

    private static OutputStream createFileOutputStream(File cvsOutputFile) {
        try {
            return new BufferedOutputStream(new FileOutputStream(cvsOutputFile, true));
        }
        catch (FileNotFoundException e) {
            return DUMMY_OUTPUT_STREAM;
        }
    }

    public OutputStream createLoggingOutputStream(final OutputStream outputStream) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                outputStream.write(b);
                StreamLogger.this.getOutputLogStream().write(b);
                StreamLogger.this.getOutputLogStream().flush();
            }

            @Override
            public void flush() throws IOException {
                outputStream.flush();
            }

            @Override
            public void close() throws IOException {
                StreamLogger.this.myCloseCount++;
                if (StreamLogger.this.myCloseCount == 2) {
                    StreamLogger.this.myLogOutput.close();
                }
            }
        };
    }

    public InputStream createLoggingInputStream(final InputStream inputStream) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                int result = inputStream.read();
                OutputStream logStream = StreamLogger.this.getInputLogStream();
                logStream.write(result);
                if (result == 10) {
                    logStream.flush();
                }
                return result;
            }

            @Override
            public void close() throws IOException {
                StreamLogger.this.myCloseCount++;
                if (StreamLogger.this.myCloseCount == 2 && StreamLogger.this.myLogOutput != null) {
                    StreamLogger.this.myLogOutput.close();
                    StreamLogger.this.myLogOutput = null;
                    StreamLogger.this.myCloseCount = 0;
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                int read = this.read();
                if (read == -1) {
                    return -1;
                }
                b[off] = (byte)read;
                return 1;
            }
        };
    }

    public OutputStream getInputLogStream() {
        if (this.myLogOutput == null) {
            this.initLogOutput();
        }
        return this.myLogOutput;
    }

    private void initLogOutput() {
        if (CvsApplicationLevelConfiguration.getInstance().DO_OUTPUT) {
            File cvsOutputFile = new File(PathManager.getLogPath(), OUTPUT_FILE_NAME);
            if (cvsOutputFile.isFile() && cvsOutputFile.length() > 1000000L) {
                FileUtil.delete((File)cvsOutputFile);
            }
            this.myLogOutput = StreamLogger.createFileOutputStream(cvsOutputFile);
        } else {
            this.myLogOutput = DUMMY_OUTPUT_STREAM;
        }
    }

    public OutputStream getOutputLogStream() {
        if (this.myLogOutput == null) {
            this.initLogOutput();
        }
        return this.myLogOutput;
    }
}

