/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.RlogCommand;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchesProvider;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.netbeans.lib.cvsclient.command.Command;

public class GetAllBranchesOperation
extends LocalPathIndifferentOperation
implements BranchesProvider {
    private final Collection<String> myTags = new HashSet();
    private static final String START = "symbolic names:";
    private static final String END = "keyword substitution:";
    private boolean myIsInBranchesMode = false;
    private final String myModuleName;

    public GetAllBranchesOperation(CvsEnvironment environment) {
        this(environment, ".");
    }

    public GetAllBranchesOperation(CvsEnvironment environment, String moduleName) {
        super(environment);
        this.myModuleName = moduleName;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        RlogCommand command = new RlogCommand();
        command.setModuleName(this.myModuleName);
        command.setSuppressEmptyHeaders(false);
        return command;
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        String trimmedMessage;
        int lastIndex;
        if (error) {
            return;
        }
        if (tagged) {
            return;
        }
        if (message.startsWith(START)) {
            this.myIsInBranchesMode = true;
            return;
        }
        if (message.startsWith(END)) {
            this.myIsInBranchesMode = false;
            return;
        }
        if (this.myIsInBranchesMode && (lastIndex = (trimmedMessage = message.trim()).indexOf(":")) >= 0) {
            this.myTags.add(trimmedMessage.substring(0, lastIndex));
        }
    }

    @Override
    public Collection<String> getAllBranches() {
        return this.myTags;
    }

    @Override
    public Collection<CvsRevisionNumber> getAllRevisions() {
        return null;
    }

    @Override
    protected String getOperationName() {
        return "rlog";
    }
}

