/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class UpdatedFilesManager
implements IMessageListener {
    private static final Pattern MERGE_PATTERN = Pattern.compile("(cvs server: revision )(.*)( from repository is now in )(.*)");
    private static final Pattern MERGING_DIFFERENCES_PATTERN = Pattern.compile("(Merging differences between )(.*)( and )(.*)( into )(.*)");
    private static final String MERGED_FILE_MESSAGE_PREFIX = "RCS file: ";
    private static final String MERGED_FILE_MESSAGE_POSTFIX = ",v";
    private final Map<File, CurrentMergedFileInfo> myMergedFiles = new HashMap<File, CurrentMergedFileInfo>();
    private final Set<File> myCreatedBySecondParty = new HashSet<File>();
    private ICvsFileSystem myCvsFileSystem;
    private static final String CREATED_BY_SECOND_PARTY_PREFIX = "cvs server: conflict: ";
    private static final String CREATED_BY_SECOND_PARTY_POSTFIX1 = " created independently by second party";
    private static final String CREATED_BY_SECOND_PARTY_POSTFIX2 = " has been added, but already exists";
    private CurrentMergedFileInfo myCurrentMergedFile;
    private final Collection<Entry> myNewlyCreatedEntries = new HashSet<Entry>();
    private final Collection<File> myNonUpdatedFiles = new HashSet<File>();

    public void setCvsFileSystem(ICvsFileSystem cvsFileSystem) {
        this.myCvsFileSystem = cvsFileSystem;
    }

    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        Matcher matcher;
        if (message.startsWith(MERGED_FILE_MESSAGE_PREFIX)) {
            String pathInRepository = message.substring(MERGED_FILE_MESSAGE_PREFIX.length(), message.length() - MERGED_FILE_MESSAGE_POSTFIX.length());
            String relativeRepositoryPath = this.myCvsFileSystem.getRelativeRepositoryPath(UpdatedFilesManager.normalizePath(pathInRepository));
            File file = this.myCvsFileSystem.getLocalFileSystem().getFile(UpdatedFilesManager.removeModuleNameFrom(relativeRepositoryPath));
            this.ensureFileIsInMap(file);
            this.myCurrentMergedFile = this.myMergedFiles.get(file);
        } else if (message.startsWith(CREATED_BY_SECOND_PARTY_PREFIX)) {
            this.processMessageWithPostfix(message, CREATED_BY_SECOND_PARTY_POSTFIX1);
            this.processMessageWithPostfix(message, CREATED_BY_SECOND_PARTY_POSTFIX2);
        } else if (MERGE_PATTERN.matcher(message).matches()) {
            Matcher matcher2 = MERGE_PATTERN.matcher(message);
            if (matcher2.matches()) {
                String relativeFileName = matcher2.group(4);
                File file = this.myCvsFileSystem.getLocalFileSystem().getFile(relativeFileName);
                this.ensureFileIsInMap(file);
            }
        } else if (MERGING_DIFFERENCES_PATTERN.matcher(message).matches() && (matcher = MERGING_DIFFERENCES_PATTERN.matcher(message)).matches()) {
            String firstRevision = matcher.group(2);
            String secondRevision = matcher.group(4);
            this.myCurrentMergedFile.addRevisions(firstRevision, secondRevision);
        }
    }

    private static String normalizePath(String pathInRepository) {
        return pathInRepository.replace(File.separatorChar, '/');
    }

    private void processMessageWithPostfix(String message, String postfix) {
        if (message.endsWith(postfix)) {
            String pathInRepository = message.substring(CREATED_BY_SECOND_PARTY_PREFIX.length(), message.length() - postfix.length());
            File ioFile = this.myCvsFileSystem.getLocalFileSystem().getFile(pathInRepository);
            this.myCreatedBySecondParty.add(ioFile);
        }
    }

    private void ensureFileIsInMap(File file) {
        if (!this.myMergedFiles.containsKey(file)) {
            this.myMergedFiles.put(file, new CurrentMergedFileInfo());
        }
    }

    private static String removeModuleNameFrom(String relativeRepositoryPath) {
        String moduleName = UpdatedFilesManager.getModuleNameFor(relativeRepositoryPath);
        if (moduleName == null) {
            return relativeRepositoryPath;
        }
        return relativeRepositoryPath.substring(moduleName.length() + 1);
    }

    private static String getModuleNameFor(String relativeRepositoryPath) {
        File file = new File(relativeRepositoryPath);
        if (file.getParentFile() == null) {
            return null;
        }
        while (file.getParentFile() != null) {
            file = file.getParentFile();
        }
        return file.getName();
    }

    public boolean isMerged(File file) {
        return this.myMergedFiles.containsKey(file);
    }

    public boolean isCreatedBySecondParty(File file) {
        return this.myCreatedBySecondParty.contains(file);
    }

    public CurrentMergedFileInfo getInfo(File file) {
        if (this.myMergedFiles.containsKey(file)) {
            return this.myMergedFiles.get(file);
        }
        return new CurrentMergedFileInfo();
    }

    public boolean isNewlyCreatedEntryFor(VirtualFile parent, String name) {
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(parent, name);
        if (entry == null) {
            return true;
        }
        if (entry.getConflictStringWithoutConflict().equals("dummy timestamp")) {
            return true;
        }
        return this.myNewlyCreatedEntries.contains(entry);
    }

    public void addNewlyCreatedEntry(Entry entry) {
        this.myNewlyCreatedEntries.add(entry);
    }

    public void couldNotUpdateFile(File file) {
        this.myMergedFiles.remove(file);
        this.myNonUpdatedFiles.add(file);
    }

    public boolean fileIsNotUpdated(File file) {
        return this.myNonUpdatedFiles.contains(file);
    }

    public void binaryMessageSent(byte[] bytes) {
    }

    public static class CurrentMergedFileInfo {
        private final List<String> myRevisions = new ArrayList<String>();
        private Entry myCurrentRevision;

        public void addRevisions(String firstRevision, String secondRevision) {
            this.addRevision(firstRevision);
            this.addRevision(secondRevision);
        }

        private void addRevision(String firstRevision) {
            if (!this.myRevisions.contains(firstRevision)) {
                this.myRevisions.add(firstRevision);
            }
        }

        public List<String> getRevisions() {
            return this.myRevisions;
        }

        public void registerNewRevision(Entry previousEntry) {
            if (this.myCurrentRevision == null) {
                this.myCurrentRevision = previousEntry;
            }
        }

        public Entry getOriginalEntry() {
            return this.myCurrentRevision;
        }
    }
}

