/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FindAllRootsHelper {
    private FindAllRootsHelper() {
    }

    public static List<VirtualFile> findVersionedUnder(List<VirtualFile> coll) {
        List pathList = ObjectsConvertor.vf2fp(coll);
        return FindAllRootsHelper.impl(pathList.iterator());
    }

    public static FilePath[] findVersionedUnder(FilePath[] roots) {
        List<VirtualFile> found = FindAllRootsHelper.impl(Arrays.asList(roots).iterator());
        return ObjectsConvertor.vf2fp(found).toArray(new FilePath[found.size()]);
    }

    private static List<VirtualFile> impl(Iterator<FilePath> iterator) {
        MyProcessor processor = new MyProcessor();
        while (iterator.hasNext()) {
            FilePath root = iterator.next();
            VirtualFile vf = root.getVirtualFile();
            if (vf == null) continue;
            VfsUtil.processFilesRecursively((VirtualFile)vf, (Processor)processor, (Convertor)processor);
        }
        return processor.getFound();
    }

    private static class MyProcessor
    implements Processor<VirtualFile>,
    Convertor<VirtualFile, Boolean> {
        private final List<VirtualFile> myFound = new LinkedList<VirtualFile>();

        private MyProcessor() {
        }

        public Boolean convert(VirtualFile o) {
            return !this.myFound.contains(o);
        }

        public boolean process(VirtualFile file) {
            if (CvsUtil.fileIsUnderCvsMaybeWithVfs(file)) {
                this.myFound.add(file);
            }
            return true;
        }

        public List<VirtualFile> getFound() {
            return this.myFound;
        }
    }
}

