/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;

public class CreateFileObjects {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.common.CreateFileObjects");
    private final File[] myFiles;
    private final String myRootPath;
    private final Map<File, AbstractFileObject> myFileToDirectoryObjectMap = new HashMap();
    private final Collection<AbstractFileObject> myResult = new ArrayList<AbstractFileObject>();
    private final Set<File> myCreatedFiles = new HashSet<File>();

    public CreateFileObjects(File root, File[] files) {
        String myRootPath = root.getAbsolutePath();
        if (myRootPath.endsWith(File.separator)) {
            myRootPath = myRootPath.substring(0, myRootPath.length() - 1);
        }
        this.myRootPath = myRootPath;
        this.myFiles = files;
    }

    public Collection<AbstractFileObject> execute() {
        for (File file : this.myFiles) {
            if (!file.isDirectory() && !file.isFile() && !file.getParentFile().isDirectory()) continue;
            String fileAbsolutePath = file.getAbsolutePath();
            String filePath = fileAbsolutePath.equals(this.myRootPath) ? "/" : fileAbsolutePath.substring(this.myRootPath.length() + 1);
            File relativeFile = new File(filePath);
            this.myResult.add(this.createAbstractFileObject(relativeFile.getParentFile(), relativeFile, file.isDirectory()));
        }
        return this.myResult;
    }

    private AbstractFileObject createDirectoryObject(File relativeFile) {
        return this.createAbstractFileObject(relativeFile.getParentFile(), relativeFile, true);
    }

    private AbstractFileObject createAbstractFileObject(File parent, File file, boolean isDirectory) {
        this.myCreatedFiles.add(file);
        String relativeFileName = "/" + file.getName();
        if (parent == null) {
            return isDirectory ? DirectoryObject.createInstance((String)relativeFileName) : FileObject.createInstance((String)relativeFileName);
        }
        DirectoryObject parentObject = this.getDirectoryObjectFor(parent);
        return isDirectory ? DirectoryObject.createInstance((DirectoryObject)parentObject, (String)relativeFileName) : FileObject.createInstance((DirectoryObject)parentObject, (String)relativeFileName);
    }

    private DirectoryObject getDirectoryObjectFor(File parent) {
        if (!this.myFileToDirectoryObjectMap.containsKey(parent)) {
            this.myFileToDirectoryObjectMap.put(parent, this.createDirectoryObject(parent));
        }
        return (DirectoryObject)this.myFileToDirectoryObjectMap.get(parent);
    }
}

