/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ext.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ext.ui.ExtConnectionSettingsPanel;
import com.intellij.cvsSupport2.connections.ssh.ui.SshConnectionSettingsPanel;
import com.intellij.cvsSupport2.ui.CvsRootChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ExtConnectionDualPanel {
    private final ExtConnectionSettingsPanel myExtSettingsPanel;
    private final SshConnectionSettingsPanel mySshSettingsPanel;
    private final Collection<CvsRootChangeListener> myCvsRootChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JPanel myDualPanel = new JPanel(new CardLayout());
    private final JCheckBox myUseInternalImplementationCheckBox = new JCheckBox(CvsBundle.message((String)"checkbox.text.use.internal.ssh.implementation", (Object[])new Object[0]));
    private static final String EXT = "EXT";
    private static final String SSH = "SSH";

    public ExtConnectionDualPanel(Project project) {
        this.myExtSettingsPanel = new ExtConnectionSettingsPanel(project);
        this.mySshSettingsPanel = new SshConnectionSettingsPanel(project);
        this.myDualPanel.add((Component)this.myExtSettingsPanel.getPanel(), EXT);
        this.myDualPanel.add((Component)this.mySshSettingsPanel.getPanel(), SSH);
        this.myPanel.add((Component)this.myUseInternalImplementationCheckBox, "North");
        this.myPanel.add((Component)this.myDualPanel, "Center");
        this.myUseInternalImplementationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConnectionDualPanel.this.updatePage();
                ExtConnectionDualPanel.this.notifyListeners();
            }
        });
    }

    public void addCvsRootChangeListener(CvsRootChangeListener l) {
        this.myCvsRootChangeListeners.add(l);
    }

    private void notifyListeners() {
        for (CvsRootChangeListener cvsRootChangeListener : this.myCvsRootChangeListeners) {
            cvsRootChangeListener.onCvsRootChanged();
        }
    }

    private void updatePage() {
        CardLayout cardLayout = (CardLayout)this.myDualPanel.getLayout();
        if (this.myUseInternalImplementationCheckBox.isSelected()) {
            cardLayout.show(this.myDualPanel, SSH);
        } else {
            cardLayout.show(this.myDualPanel, EXT);
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void updateFrom(ExtConfiguration extConfiguration, SshSettings sshSettings) {
        this.myExtSettingsPanel.updateFrom(extConfiguration);
        this.mySshSettingsPanel.updateFrom(sshSettings);
        this.myUseInternalImplementationCheckBox.setSelected(extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION);
        this.updatePage();
    }

    public boolean equalsTo(ExtConfiguration extConfiguration, SshSettings sshSettings) {
        if (!this.myExtSettingsPanel.equalsTo(extConfiguration)) {
            return false;
        }
        if (!this.mySshSettingsPanel.equalsTo(sshSettings)) {
            return false;
        }
        return this.myUseInternalImplementationCheckBox.isSelected() == extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION;
    }

    public void saveTo(ExtConfiguration extConfiguration, SshSettings sshSettings) {
        this.myExtSettingsPanel.saveTo(extConfiguration);
        this.mySshSettingsPanel.saveTo(sshSettings);
        extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION = this.myUseInternalImplementationCheckBox.isSelected();
    }

    public boolean isUseInternalSshImplementation() {
        return this.myUseInternalImplementationCheckBox.isSelected();
    }
}

