/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.javacvsImpl.io.InputStreamWrapper;
import com.intellij.cvsSupport2.javacvsImpl.io.OutputStreamWrapper;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.ICvsCommandStopper;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class ConnectionWrapper
implements IConnection {
    protected final IConnection mySourceConnection;
    private InputStream myInputStreamWrapper;
    private OutputStreamWrapper myOutputStreamWrapper;
    private final ReadWriteStatistics myStatistics;
    private final ICvsCommandStopper myCommandStopper;
    private static final String CVS_DONT_READ_IN_THREAD_PROPERTY = "cvs.dont.read.in.thread";

    public ConnectionWrapper(IConnection sourceConnection, ReadWriteStatistics statistics, ICvsCommandStopper commandStopper) {
        this.mySourceConnection = sourceConnection;
        this.myStatistics = statistics;
        this.myCommandStopper = commandStopper;
    }

    public InputStream getInputStream() {
        if (this.myInputStreamWrapper == null) {
            this.myInputStreamWrapper = Boolean.TRUE.toString().equals(System.getProperty(CVS_DONT_READ_IN_THREAD_PROPERTY)) ? this.mySourceConnection.getInputStream() : new InputStreamWrapper(this.mySourceConnection.getInputStream(), this.myCommandStopper, this.myStatistics);
        }
        return this.myInputStreamWrapper;
    }

    public OutputStream getOutputStream() {
        if (this.myOutputStreamWrapper == null) {
            this.myOutputStreamWrapper = new OutputStreamWrapper(this.mySourceConnection.getOutputStream(), this.myStatistics);
        }
        return this.myOutputStreamWrapper;
    }

    public String getRepository() {
        return this.mySourceConnection.getRepository();
    }

    public void verify(IStreamLogger streamLogger) throws AuthenticationException {
        this.mySourceConnection.verify(streamLogger);
    }

    public void open(IStreamLogger streamLogger) throws AuthenticationException {
        this.mySourceConnection.open(streamLogger);
    }

    public void close() throws IOException {
        if (this.myInputStreamWrapper != null) {
            this.myInputStreamWrapper.close();
            this.myInputStreamWrapper = null;
            this.myOutputStreamWrapper = null;
        }
        this.mySourceConnection.close();
    }
}

