/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.cvsSupport2.changeBrowser.CvsChangeList;
import com.intellij.cvsSupport2.changeBrowser.LogInformationWrapper;
import com.intellij.cvsSupport2.changeBrowser.RevisionWrapper;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class CvsChangeListsBuilder {
    private static final String INITIALLY_ADDED_ON_BRANCH = "was initially added on branch";
    private final Map<ChangeListKey, List<CvsChangeList>> myCache = new HashMap<ChangeListKey, List<CvsChangeList>>();
    private long myLastNumber = 0L;
    private final String myRootPath;
    private final CvsEnvironment myEnvironment;
    private final Project myProject;
    private final VirtualFile myRootFile;

    public CvsChangeListsBuilder(String rootPath, CvsEnvironment environment, Project project, VirtualFile rootFile) {
        this.myRootPath = rootPath;
        this.myEnvironment = environment;
        this.myProject = project;
        this.myRootFile = rootFile;
    }

    public List<CvsChangeList> getVersions() {
        ArrayList<CvsChangeList> result = new ArrayList<CvsChangeList>();
        for (List<CvsChangeList> versions : this.myCache.values()) {
            result.addAll(versions);
        }
        return result;
    }

    public CvsChangeList addRevision(RevisionWrapper revisionWrapper) {
        Revision revision = revisionWrapper.getRevision();
        CvsChangeList version = this.findOrCreateVersionFor(revision.getMessage(), revisionWrapper.getTime(), revision.getAuthor(), revisionWrapper.getBranch(), revisionWrapper.getFile());
        version.addFileRevision(revisionWrapper);
        return version;
    }

    private CvsChangeList findOrCreateVersionFor(String message, long date, String author, String branch, String path) {
        ChangeListKey key = new ChangeListKey(branch, author, message);
        List<CvsChangeList> versions = this.myCache.get((Object)key);
        if (versions != null) {
            for (int i = versions.size() - 1; i >= 0; --i) {
                CvsChangeList version = versions.get(i);
                if (!version.containsDate(date) || version.containsFile(path)) continue;
                return version;
            }
        }
        CvsChangeList result = new CvsChangeList(this.myProject, this.myEnvironment, this.myRootFile, this.myLastNumber, message, date, author, this.myRootPath);
        ++this.myLastNumber;
        if (!this.myCache.containsKey((Object)key)) {
            this.myCache.put(key, new ArrayList());
        }
        this.myCache.get((Object)key).add(result);
        return result;
    }

    public List<RevisionWrapper> revisionWrappersFromLog(LogInformationWrapper log) {
        String file = log.getFile();
        if (!CvsChangeList.isAncestor(this.myRootPath, file)) {
            return null;
        }
        ArrayList<RevisionWrapper> result = new ArrayList<RevisionWrapper>();
        for (Revision revision : log.getRevisions()) {
            if (revision == null || "dead".equals(revision.getState()) && revision.getMessage().contains(INITIALLY_ADDED_ON_BRANCH)) continue;
            String branchName = CvsChangeListsBuilder.getBranchName(revision, log.getSymbolicNames());
            result.add(new RevisionWrapper(file, revision, branchName));
        }
        return result;
    }

    public void add(LogInformationWrapper log) {
        List<RevisionWrapper> wrappers = this.revisionWrappersFromLog(log);
        if (wrappers == null) {
            return;
        }
        for (RevisionWrapper wrapper : wrappers) {
            this.addRevision(wrapper);
        }
    }

    private static String getBranchName(Revision revision, List<SymbolicName> symbolicNames) {
        String branches;
        CvsRevisionNumber number = new CvsRevisionNumber(revision.getNumber().trim());
        int[] subRevisions = number.getSubRevisions();
        String branchNumberString = null;
        if (subRevisions != null && subRevisions.length >= 4) {
            int branchRevNumber = subRevisions[subRevisions.length - 2];
            CvsRevisionNumber branchNumber = number.removeTailVersions(2).addTailVersions(new int[]{0, branchRevNumber});
            branchNumberString = branchNumber.asString();
        }
        if (branchNumberString == null && (branches = revision.getBranches()) != null && branches.length() > 0) {
            String[] branchNames = branches.split(";");
            CvsRevisionNumber revisionNumber = new CvsRevisionNumber(branchNames[0].trim());
            int[] branchSubRevisions = revisionNumber.getSubRevisions();
            assert (branchSubRevisions != null);
            int rev = branchSubRevisions[branchSubRevisions.length - 1];
            CvsRevisionNumber branchNumber = revisionNumber.removeTailVersions(1).addTailVersions(new int[]{0, rev});
            branchNumberString = branchNumber.asString();
        }
        if (branchNumberString != null) {
            for (SymbolicName name : symbolicNames) {
                if (!name.getRevision().equals(branchNumberString)) continue;
                return name.getName();
            }
        }
        return null;
    }

    private static class ChangeListKey
    extends Trinity<String, String, String> {
        public ChangeListKey(String branch, String author, String message) {
            super((Object)branch, (Object)author, (Object)message);
        }
    }
}

