/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;

public class SubstitutedExpressionEvaluationHelper {
    private final PsiConstantEvaluationHelper myHelper;
    private final Configuration myConfiguration;

    public SubstitutedExpressionEvaluationHelper(Project project) {
        this.myHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
        this.myConfiguration = Configuration.getInstance();
    }

    public Object computeExpression(PsiExpression e, List<PsiExpression> uncomputables) {
        return this.computeExpression(e, this.myConfiguration.getAdvancedConfiguration().getDfaOption(), this.myConfiguration.getAdvancedConfiguration().isIncludeUncomputablesAsLiterals(), uncomputables);
    }

    public Object computeExpression(PsiExpression e, final Configuration.DfaOption dfaOption, final boolean includeUncomputablesAsLiterals, final List<PsiExpression> uncomputables) {
        final ConcurrentMap map = ContainerUtil.newConcurrentMap();
        return this.myHelper.computeExpression(e, false, new PsiConstantEvaluationHelper.AuxEvaluator(){

            public Object computeExpression(PsiExpression o, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
                PsiElement resolved;
                PsiType resolvedType = null;
                if (o instanceof PsiMethodCallExpression) {
                    Object substituted;
                    PsiType returnType;
                    PsiMethodCallExpression c = (PsiMethodCallExpression)o;
                    PsiMethod m = (PsiMethod)c.getMethodExpression().resolve();
                    PsiType psiType = returnType = m != null ? m.getReturnType() : null;
                    if (returnType != null && returnType != PsiType.VOID && (substituted = SubstitutedExpressionEvaluationHelper.this.calcSubstituted((PsiModifierListOwner)m)) != null) {
                        return substituted;
                    }
                    resolvedType = returnType;
                } else if (o instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)o).resolve()) instanceof PsiModifierListOwner) {
                    Object substituted = SubstitutedExpressionEvaluationHelper.this.calcSubstituted((PsiModifierListOwner)resolved);
                    if (substituted != null) {
                        return substituted;
                    }
                    if (resolved instanceof PsiVariable) {
                        Collection realValues;
                        PsiVariable psiVariable = (PsiVariable)resolved;
                        resolvedType = psiVariable.getType();
                        Collection<Object> values = dfaOption == Configuration.DfaOption.ASSIGNMENTS ? DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)psiVariable, (boolean)true, (PsiElement)o) : (dfaOption == Configuration.DfaOption.DFA ? ((realValues = DfaUtil.getCachedVariableValues((PsiVariable)psiVariable, (PsiElement)o)) == null ? DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)psiVariable, (boolean)true, (PsiElement)o) : realValues) : Collections.emptyList());
                        for (PsiExpression value : values) {
                            Object computedValue = auxEvaluator.computeExpression(value, (PsiConstantEvaluationHelper.AuxEvaluator)this);
                            if (computedValue == null) continue;
                            return computedValue;
                        }
                    }
                }
                if (uncomputables != null) {
                    uncomputables.add(o);
                }
                if (includeUncomputablesAsLiterals) {
                    if (resolvedType != null && PsiPrimitiveType.DOUBLE.isAssignableFrom(resolvedType)) {
                        return 1;
                    }
                    final StringBuilder sb = new StringBuilder();
                    o.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            if (element instanceof PsiExpressionList) {
                                return;
                            }
                            if (element instanceof PsiIdentifier) {
                                if (sb.length() > 0) {
                                    sb.append(".");
                                }
                                sb.append(element.getText());
                            }
                            super.visitElement(element);
                        }
                    });
                    return sb.toString();
                }
                return null;
            }

            public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
                return map;
            }
        });
    }

    private Object calcSubstituted(PsiModifierListOwner owner) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Set)((Set)this.myConfiguration.getAdvancedConfiguration().getSubstAnnotationPair().second));
        if (annotation != null) {
            return AnnotationUtilEx.calcAnnotationValue(annotation, "value");
        }
        return null;
    }
}

