/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java.validation;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;

public class LanguageMismatch
extends LocalInspectionTool {
    public boolean CHECK_NON_ANNOTATED_REFERENCES = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    public String getGroupDisplayName() {
        return "Language Injection";
    }

    public String getDisplayName() {
        return "Language Mismatch";
    }

    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JCheckBox jCheckBox = new JCheckBox("Flag usages of non-annotated elements where the usage context implies a certain language");
        jCheckBox.setSelected(this.CHECK_NON_ANNOTATED_REFERENCES);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LanguageMismatch.this.CHECK_NON_ANNOTATED_REFERENCES = jCheckBox.isSelected();
            }
        });
        jPanel.add((Component)jCheckBox, "North");
        return jPanel;
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getLanguageAnnotationPair();
            }

            public void visitExpression(PsiExpression expression) {
                LanguageMismatch.this.checkExpression(expression, holder, (Pair<String, ? extends Set<String>>)this.annotationName);
            }

            public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
                PsiExpression expr = expression.getExpression();
                if (expr != null) {
                    expr.accept((PsiElementVisitor)this);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement element = expression.resolve();
                if (!(element instanceof PsiModifierListOwner)) {
                    return;
                }
                LanguageMismatch.this.checkExpression((PsiExpression)expression, holder, (Pair<String, ? extends Set<String>>)this.annotationName);
            }
        };
    }

    private void checkExpression(PsiExpression expression, ProblemsHolder holder, Pair<String, ? extends Set<String>> annotationName) {
        PsiModifierListOwner declOwner;
        String expected;
        PsiAnnotation[] annotations;
        PsiType type = expression.getType();
        if (type == null || !PsiUtilEx.isStringOrStringArray(type)) {
            return;
        }
        PsiModifierListOwner contextOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.CONTEXT_ONLY);
        if (contextOwner != null && PsiUtilEx.isLanguageAnnotationTarget(contextOwner) && (annotations = AnnotationUtilEx.getAnnotationFrom(contextOwner, annotationName, true)).length > 0 && (expected = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null && (declOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION)) != null && PsiUtilEx.isLanguageAnnotationTarget(declOwner)) {
            PsiAnnotation[] as = AnnotationUtilEx.getAnnotationFrom(declOwner, annotationName, true);
            if (as.length > 0) {
                String actual = AnnotationUtilEx.calcAnnotationValue(as, "value");
                if (!expected.equals(actual)) {
                    holder.registerProblem((PsiElement)expression, "Language mismatch: Expected '" + expected + "', got '" + actual + "'", new LocalQuickFix[0]);
                }
            } else if (this.CHECK_NON_ANNOTATED_REFERENCES) {
                PsiAssignmentExpression a;
                PsiExpressionList list;
                PsiElement var = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiVariable.class, PsiExpressionList.class, PsiAssignmentExpression.class});
                if (var instanceof PsiVariable ? ((PsiVariable)var).getInitializer() != expression : (var instanceof PsiExpressionList ? Arrays.asList((list = (PsiExpressionList)var).getExpressions()).indexOf(expression) == -1 : var instanceof PsiAssignmentExpression && (a = (PsiAssignmentExpression)var).getRExpression() != expression)) {
                    return;
                }
                PsiAnnotation annotation = annotations[annotations.length - 1];
                final String initializer = annotation.getParameterList().getText();
                AnnotateFix fix = new AnnotateFix(declOwner, annotation.getQualifiedName(), initializer){

                    @Override
                    public String getName() {
                        return initializer == null ? super.getName() : super.getName() + initializer;
                    }
                };
                if (fix.canApply()) {
                    holder.registerProblem((PsiElement)expression, "Language problem: Found non-annotated reference where '" + expected + "' is expected", new LocalQuickFix[]{fix});
                } else {
                    holder.registerProblem((PsiElement)expression, "Language problem: Found non-annotated reference where '" + expected + "' is expected", new LocalQuickFix[0]);
                }
            }
        }
    }

    public String getShortName() {
        return "LanguageMismatch";
    }
}

