/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;

public class XmlTagInjection
extends AbstractTagInjection {
    public XmlTagInjection() {
        this.setTagName("<none>");
    }

    public boolean isApplicable(XmlTag context) {
        return this.matches(context) && this.matchXPath((XmlElement)context);
    }

    public String getGeneratedName() {
        String name = this.getTagName();
        return name.length() > 0 ? name : "*";
    }

    @Override
    public XmlTagInjection copy() {
        return new XmlTagInjection().copyFrom(this);
    }

    @Override
    public XmlTagInjection copyFrom(BaseInjection o) {
        super.copyFrom(o);
        return this;
    }

    @Override
    public void generatePlaces() {
        if (StringUtil.isEmpty((String)this.getDisplayName())) {
            this.setDisplayName(this.getGeneratedName());
        }
        this.setInjectionPlaces(new InjectionPlace((ElementPattern<PsiElement>)this.getCompiler().createElementPattern(XmlTagInjection.getPatternString(this), this.getDisplayName()), true));
    }

    public static String getPatternString(AbstractTagInjection injection) {
        String name = injection.getTagName();
        String namespace = injection.getTagNamespace();
        StringBuilder result = new StringBuilder("xmlTag()");
        if (StringUtil.isNotEmpty((String)name)) {
            InjectorUtils.appendStringPattern(result, ".withLocalName(", name, ")");
        }
        if (StringUtil.isNotEmpty((String)namespace)) {
            InjectorUtils.appendStringPattern(result, ".withNamespace(", namespace, ")");
        }
        return result.toString();
    }
}

