/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.Injection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class BaseInjection
implements Injection,
PersistentStateComponent<Element> {
    public static final Key<BaseInjection> INJECTION_KEY = Key.create((String)"INJECTION_KEY");
    private final String mySupportId;
    private String myDisplayName = "";
    private String myInjectedLanguageId = "";
    private String myPrefix = "";
    private String mySuffix = "";
    private String myValuePattern = "";
    private Pattern myCompiledValuePattern;
    private boolean mySingleFile;
    private InjectionPlace[] myPlaces = InjectionPlace.EMPTY_ARRAY;

    public BaseInjection(String id) {
        this.mySupportId = id;
    }

    public InjectionPlace[] getInjectionPlaces() {
        return this.myPlaces;
    }

    public void setInjectionPlaces(InjectionPlace ... places) {
        this.myPlaces = places;
    }

    public String getSupportId() {
        return this.mySupportId;
    }

    @Override
    public String getInjectedLanguageId() {
        return this.myInjectedLanguageId;
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    public void setInjectedLanguageId(String injectedLanguageId) {
        this.myInjectedLanguageId = injectedLanguageId;
    }

    @Override
    public String getPrefix() {
        return this.myPrefix;
    }

    public void setPrefix(String prefix) {
        this.myPrefix = prefix;
    }

    @Override
    public String getSuffix() {
        return this.mySuffix;
    }

    public void setSuffix(String suffix) {
        this.mySuffix = suffix;
    }

    @Override
    public List<TextRange> getInjectedArea(PsiElement element) {
        final TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        if (this.myCompiledValuePattern == null) {
            return Collections.singletonList(textRange);
        }
        final LiteralTextEscaper textEscaper = ((PsiLanguageInjectionHost)element).createLiteralTextEscaper();
        StringBuilder sb = new StringBuilder();
        textEscaper.decode(textRange, sb);
        List<TextRange> ranges = BaseInjection.getMatchingRanges(this.myCompiledValuePattern.matcher(StringPattern.newBombedCharSequence((CharSequence)sb)), sb.length());
        return !ranges.isEmpty() ? ContainerUtil.map(ranges, (Function)new Function<TextRange, TextRange>(){

            public TextRange fun(TextRange s) {
                return new TextRange(textEscaper.getOffsetInHost(s.getStartOffset(), textRange), textEscaper.getOffsetInHost(s.getEndOffset(), textRange));
            }
        }) : Collections.emptyList();
    }

    public boolean isEnabled() {
        for (InjectionPlace place : this.myPlaces) {
            if (place.getElementPattern() == null || !place.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsPsiElement(PsiElement element) {
        ProgressManager.checkCanceled();
        for (InjectionPlace place : this.myPlaces) {
            if (!place.isEnabled() || place.getElementPattern() == null || !place.getElementPattern().accepts((Object)element)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsWith(BaseInjection template) {
        if (!Comparing.equal((String)this.getInjectedLanguageId(), (String)template.getInjectedLanguageId())) {
            return false;
        }
        for (InjectionPlace other : template.getInjectionPlaces()) {
            if (!ArrayUtil.contains((Object)other, (Object[])this.myPlaces)) continue;
            return true;
        }
        return false;
    }

    public boolean sameLanguageParameters(BaseInjection that) {
        if (!this.myInjectedLanguageId.equals(that.myInjectedLanguageId)) {
            return false;
        }
        if (!this.myPrefix.equals(that.myPrefix)) {
            return false;
        }
        if (!this.mySuffix.equals(that.mySuffix)) {
            return false;
        }
        if (!this.myValuePattern.equals(that.myValuePattern)) {
            return false;
        }
        return this.mySingleFile == that.mySingleFile;
    }

    public BaseInjection copy() {
        return new BaseInjection(this.mySupportId).copyFrom(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BaseInjection)) {
            return false;
        }
        BaseInjection that = (BaseInjection)o;
        if (!Comparing.equal((String)this.getDisplayName(), (String)that.getDisplayName())) {
            return false;
        }
        if (!this.sameLanguageParameters(that)) {
            return false;
        }
        if (this.myPlaces.length != that.myPlaces.length) {
            return false;
        }
        int len = this.myPlaces.length;
        for (int i = 0; i < len; ++i) {
            if (this.myPlaces[i].isEnabled() == that.myPlaces[i].isEnabled()) continue;
            return false;
        }
        return Arrays.equals(this.myPlaces, that.myPlaces);
    }

    public int hashCode() {
        int result = this.myInjectedLanguageId.hashCode();
        result = 31 * result + this.myPrefix.hashCode();
        result = 31 * result + this.mySuffix.hashCode();
        result = 31 * result + this.myValuePattern.hashCode();
        return result;
    }

    public BaseInjection copyFrom(BaseInjection other) {
        assert (this != other);
        this.myInjectedLanguageId = other.getInjectedLanguageId();
        this.myPrefix = other.getPrefix();
        this.mySuffix = other.getSuffix();
        this.myDisplayName = other.getDisplayName();
        this.setValuePattern(other.getValuePattern());
        this.mySingleFile = other.mySingleFile;
        this.myPlaces = (InjectionPlace[])other.getInjectionPlaces().clone();
        return this;
    }

    public void loadState(Element element) {
        PatternCompiler<PsiElement> helper = this.getCompiler();
        this.myDisplayName = StringUtil.notNullize((String)element.getChildText("display-name"));
        this.myInjectedLanguageId = StringUtil.notNullize((String)element.getAttributeValue("language"));
        this.myPrefix = StringUtil.notNullize((String)element.getChildText("prefix"));
        this.mySuffix = StringUtil.notNullize((String)element.getChildText("suffix"));
        this.setValuePattern(element.getChildText("value-pattern"));
        this.mySingleFile = element.getChild("single-file") != null;
        this.readExternalImpl(element);
        List placeElements = element.getChildren("place");
        this.myPlaces = (InjectionPlace[])InjectionPlace.ARRAY_FACTORY.create(placeElements.size());
        int placeElementsSize = placeElements.size();
        for (int i = 0; i < placeElementsSize; ++i) {
            Element placeElement = (Element)placeElements.get(i);
            boolean enabled = !Boolean.parseBoolean(placeElement.getAttributeValue("disabled"));
            String text = placeElement.getText();
            this.myPlaces[i] = new InjectionPlace((ElementPattern<PsiElement>)helper.createElementPattern(text, this.getDisplayName()), enabled);
        }
        if (this.myPlaces.length == 0) {
            this.generatePlaces();
        }
    }

    public PatternCompiler<PsiElement> getCompiler() {
        return PatternCompilerFactory.getFactory().getPatternCompiler(InjectorUtils.getPatternClasses(this.getSupportId()));
    }

    public void generatePlaces() {
    }

    protected void readExternalImpl(Element e) {
    }

    public final Element getState() {
        Element e = new Element("injection");
        e.setAttribute("language", this.myInjectedLanguageId);
        e.setAttribute("injector-id", this.mySupportId);
        e.addContent(new Element("display-name").setText(this.getDisplayName()));
        if (StringUtil.isNotEmpty((String)this.myPrefix)) {
            e.addContent(new Element("prefix").setText(this.myPrefix));
        }
        if (StringUtil.isNotEmpty((String)this.mySuffix)) {
            e.addContent(new Element("suffix").setText(this.mySuffix));
        }
        if (StringUtil.isNotEmpty((String)this.myValuePattern)) {
            e.addContent(new Element("value-pattern").setText(this.myValuePattern));
        }
        if (this.mySingleFile) {
            e.addContent(new Element("single-file"));
        }
        Arrays.sort(this.myPlaces, new Comparator<InjectionPlace>(){

            @Override
            public int compare(InjectionPlace o1, InjectionPlace o2) {
                return Comparing.compare((Comparable)((Object)o1.getText()), (Comparable)((Object)o2.getText()));
            }
        });
        for (InjectionPlace place : this.myPlaces) {
            Element child = new Element("place").setContent((Content)new CDATA(place.getText()));
            if (!place.isEnabled()) {
                child.setAttribute("disabled", "true");
            }
            e.addContent(child);
        }
        this.writeExternalImpl(e);
        return e;
    }

    protected void writeExternalImpl(Element e) {
    }

    public String getValuePattern() {
        return this.myValuePattern;
    }

    public void setValuePattern(@RegExp String pattern) {
        try {
            if (pattern != null && pattern.length() > 0) {
                this.myValuePattern = pattern;
                this.myCompiledValuePattern = Pattern.compile(pattern, 32);
            } else {
                this.myValuePattern = "";
                this.myCompiledValuePattern = null;
            }
        }
        catch (Exception e1) {
            this.myCompiledValuePattern = null;
            Logger.getInstance((String)this.getClass().getName()).info("Invalid pattern", (Throwable)e1);
        }
    }

    public boolean isSingleFile() {
        return this.mySingleFile;
    }

    public void setSingleFile(boolean singleFile) {
        this.mySingleFile = singleFile;
    }

    public boolean isTerminal() {
        return this.myCompiledValuePattern == null;
    }

    private static List<TextRange> getMatchingRanges(Matcher matcher, int length) {
        SmartList list = new SmartList();
        int start = 0;
        while (start < length && matcher.find(start)) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                start = matcher.end();
                continue;
            }
            for (int i = 1; i <= groupCount; ++i) {
                start = matcher.start(i);
                if (start == -1) continue;
                list.add(new TextRange(start, matcher.end(i)));
            }
            if (start >= matcher.end()) break;
            start = matcher.end();
        }
        return list;
    }

    public void mergeOriginalPlacesFrom(BaseInjection injection, boolean enabled) {
        for (InjectionPlace place : injection.getInjectionPlaces()) {
            if (ArrayUtil.contains((Object)place, (Object[])this.myPlaces)) continue;
            this.myPlaces = (InjectionPlace[])ArrayUtil.append((Object[])this.myPlaces, (Object)(enabled || !place.isEnabled() ? place : place.enabled(false)), InjectionPlace.ARRAY_FACTORY);
        }
    }

    public void setPlaceEnabled(String text, boolean enabled) {
        for (int i = 0; i < this.myPlaces.length; ++i) {
            InjectionPlace cur = this.myPlaces[i];
            if (text != null && !Comparing.equal((String)text, (String)cur.getText()) || cur.isEnabled() == enabled) continue;
            this.myPlaces[i] = cur.enabled(enabled);
        }
    }

    public boolean acceptForReference(PsiElement element) {
        return this.acceptsPsiElement(element);
    }

    public String toString() {
        return this.getInjectedLanguageId() + "->" + this.getDisplayName();
    }
}

