/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.google.gct.login.GoogleLoginUtils;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.IUserPropertyCallback;
import com.google.gdt.eclipse.login.common.GoogleLoginState;
import java.awt.Image;

public class CredentialedUser {
    private String name;
    private Image image;
    private final String email;
    private final Credential credential;
    private boolean isActive = false;
    private final GoogleLoginState googleLoginState;

    protected CredentialedUser(String email) {
        this.email = email;
        this.name = "";
        this.credential = null;
        this.image = null;
        this.googleLoginState = null;
    }

    public CredentialedUser(GoogleLoginState state, final IGoogleLoginCompletedCallback updateUserCallback) {
        this.email = state.getEmail();
        this.googleLoginState = state;
        this.credential = this.googleLoginState.makeCredential();
        IUserPropertyCallback<Userinfoplus> callback = new IUserPropertyCallback<Userinfoplus>(){

            @Override
            public void setProperty(Userinfoplus userinfoplus) {
                CredentialedUser.this.initializeUserInfo(userinfoplus, updateUserCallback);
            }
        };
        GoogleLoginUtils.getUserInfo(this.credential, callback);
    }

    public String getEmail() {
        return this.email;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getName() {
        return this.name;
    }

    public Image getPicture() {
        return this.image;
    }

    public GoogleLoginState getGoogleLoginState() {
        return this.googleLoginState;
    }

    protected void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    private void initializeUserInfo(Userinfoplus userInfo, final IGoogleLoginCompletedCallback updateUserCallback) {
        if (userInfo == null) {
            this.name = null;
            this.image = null;
        } else {
            this.name = userInfo.getName();
            IUserPropertyCallback<Image> pictureCallback = new IUserPropertyCallback<Image>(){

                @Override
                public void setProperty(Image newImage) {
                    CredentialedUser.this.image = newImage;
                    updateUserCallback.onLoginCompleted();
                }
            };
            GoogleLoginUtils.provideUserPicture(userInfo, pictureCallback);
        }
    }
}

