/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.netbeans.lib.cvsclient.SmartCvsSrcBundle;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.IFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;
import org.netbeans.lib.cvsclient.file.IReaderFactory;
import org.netbeans.lib.cvsclient.file.IReceiveTextFilePreprocessor;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class LocalFileWriter
implements ILocalFileWriter {
    private static final int BUFFER_SIZE = 131072;
    private final IReceiveTextFilePreprocessor receiveTextFilePreprocessor;
    private Date modifiedDate;
    private String nextFileMode;
    private static final String RECEIVING_TMP_FILE_NAME = "receiving";

    public LocalFileWriter(IReceiveTextFilePreprocessor receiveTextFilePreprocessor) {
        BugLog.getInstance().assertNotNull((Object)receiveTextFilePreprocessor);
        this.receiveTextFilePreprocessor = receiveTextFilePreprocessor;
    }

    public void writeTextFile(FileObject fileObject, int length, InputStream inputStream, boolean readOnly, IReaderFactory readerFactory, IFileReadOnlyHandler fileReadOnlyHandler, IFileSystem fileSystem, Charset charSet) throws IOException {
        File localFile = fileSystem.getFile((AbstractFileObject)fileObject);
        localFile.getParentFile().mkdirs();
        if (localFile.exists()) {
            LocalFileWriter.deleteFile(localFile, fileReadOnlyHandler);
        } else {
            FileUtil.createIfDoesntExist((File)localFile);
        }
        this.receiveTextFilePreprocessor.copyTextFileToLocation(inputStream, length, localFile, readerFactory, charSet);
        this.setModifiedDateAndMode(localFile, fileReadOnlyHandler);
        fileReadOnlyHandler.setFileReadOnly(localFile, readOnly);
    }

    public void writeBinaryFile(FileObject fileObject, int length, InputStream inputStream, boolean readOnly, IFileReadOnlyHandler fileReadOnlyHandler, ICvsFileSystem cvsFileSystem) throws IOException {
        File localFile = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        localFile.getParentFile().mkdirs();
        LocalFileWriter.deleteFile(localFile, fileReadOnlyHandler);
        LocalFileWriter.writeFile(localFile, length, inputStream);
        this.setModifiedDateAndMode(localFile, fileReadOnlyHandler);
        fileReadOnlyHandler.setFileReadOnly(localFile, readOnly);
    }

    public void removeLocalFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        File file = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        LocalFileWriter.deleteFile(file, fileReadOnlyHandler);
    }

    public void renameLocalFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, String newFileName) {
        File originalFile = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        File targetFile = new File(originalFile.getParentFile(), newFileName);
        try {
            FileUtil.rename((File)originalFile, (File)targetFile);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void setNextFileDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public void setNextFileMode(String nextFileMode) {
        this.nextFileMode = nextFileMode;
    }

    private static void deleteFile(File file, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.canWrite()) {
            fileReadOnlyHandler.setFileReadOnly(file, false);
        }
        if (!file.delete()) {
            throw new IOException(SmartCvsSrcBundle.message("could.not.delete.file.error.message", file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, int length, InputStream inputStream) throws IOException {
        if (length == 0) {
            FileUtil.createIfDoesntExist((File)file);
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int bytesRead;
            byte[] chunk = new byte[131072];
            for (int size = length; size > 0; size -= bytesRead) {
                int bytesToRead = Math.min(size, chunk.length);
                bytesRead = inputStream.read(chunk, 0, bytesToRead);
                if (bytesRead < 0) {
                    break;
                }
                ((OutputStream)fileOutputStream).write(chunk, 0, bytesRead);
            }
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException ex) {}
        }
    }

    private void setModifiedDateAndMode(File localFile, IFileReadOnlyHandler readOnlyHandler) throws IOException {
        if (this.modifiedDate != null) {
            localFile.setLastModified(this.modifiedDate.getTime());
            this.modifiedDate = null;
        }
        if (this.nextFileMode != null) {
            readOnlyHandler.setFileReadOnly(localFile, FileUtils.isReadOnlyMode((String)this.nextFileMode));
            this.nextFileMode = null;
        }
    }
}

