/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PropertyFoldingBuilder
extends FoldingBuilderEx {
    private static final int FOLD_MAX_LENGTH = 50;
    private static final Key<IProperty> CACHE = Key.create((String)"i18n.property.cache");
    public static final IProperty NULL = new PropertyImpl((PropertyStub)new PropertyStubImpl(null, null), PropertiesElementTypes.PROPERTY);

    public FoldingDescriptor[] buildFoldRegions(PsiElement element, Document document, boolean quick) {
        if (!(element instanceof PsiJavaFile) || quick || !PropertyFoldingBuilder.isFoldingsOn()) {
            return FoldingDescriptor.EMPTY;
        }
        PsiJavaFile file = (PsiJavaFile)element;
        final Project project = file.getProject();
        final ArrayList result = new ArrayList();
        boolean hasJsp = ContainerUtil.intersects(Arrays.asList(StdLanguages.JSP, StdLanguages.JSPX), (Collection)file.getViewProvider().getLanguages());
        file.accept((PsiElementVisitor)(hasJsp ? new JavaRecursiveElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PropertyFoldingBuilder.checkLiteral(project, expression, result);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PropertyFoldingBuilder.checkLiteral(project, expression, result);
            }
        }));
        return result.toArray(new FoldingDescriptor[result.size()]);
    }

    private static boolean isFoldingsOn() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    private static void checkLiteral(Project project, PsiLiteralExpression expression, List<FoldingDescriptor> result) {
        if (PropertyFoldingBuilder.isI18nProperty(project, expression)) {
            IProperty property = PropertyFoldingBuilder.getI18nProperty(project, expression);
            HashSet<IProperty> set = new HashSet<IProperty>();
            set.add((IProperty)(property != null ? property : PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
            String msg = PropertyFoldingBuilder.formatI18nProperty(expression, property);
            PsiElement parent = expression.getParent();
            if (!msg.equals(expression.getText()) && parent instanceof PsiExpressionList && ((PsiExpressionList)parent).getExpressions()[0] == expression) {
                PsiExpressionList expressions = (PsiExpressionList)parent;
                int count = JavaI18nUtil.getPropertyValueParamsMaxCount((PsiExpression)expression);
                PsiExpression[] args = expressions.getExpressions();
                if (args.length == 1 + count && parent.getParent() instanceof PsiMethodCallExpression) {
                    boolean ok = true;
                    for (int i = 1; i < count + 1; ++i) {
                        Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)args[i], (boolean)false);
                        if (value != null || args[i] instanceof PsiReferenceExpression) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        result.add(new FoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)parent.getParent().getNode()), parent.getParent().getTextRange(), null, set));
                        return;
                    }
                }
            }
            result.add(new FoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)expression.getNode()), expression.getTextRange(), null, set));
        }
    }

    public String getPlaceholderText(ASTNode node) {
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (element instanceof PsiLiteralExpression) {
            return PropertyFoldingBuilder.getI18nMessage(element.getProject(), (PsiLiteralExpression)element);
        }
        if (element instanceof PsiMethodCallExpression) {
            return PropertyFoldingBuilder.formatMethodCallExpression(element.getProject(), (PsiMethodCallExpression)element);
        }
        return element.getText();
    }

    private static String formatMethodCallExpression(Project project, PsiMethodCallExpression methodCallExpression) {
        int count;
        PsiExpression[] args = methodCallExpression.getArgumentList().getExpressions();
        if (args.length > 0 && args[0] instanceof PsiLiteralExpression && args[0].isValid() && PropertyFoldingBuilder.isI18nProperty(project, (PsiLiteralExpression)args[0]) && args.length == 1 + (count = JavaI18nUtil.getPropertyValueParamsMaxCount((PsiExpression)((PsiLiteralExpression)args[0])))) {
            String text = PropertyFoldingBuilder.getI18nMessage(project, (PsiLiteralExpression)args[0]);
            for (int i = 1; i < count + 1; ++i) {
                Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)args[i], (boolean)false);
                if (value == null) {
                    if (args[i] instanceof PsiReferenceExpression) {
                        value = "{" + args[i].getText() + "}";
                    } else {
                        text = null;
                        break;
                    }
                }
                text = text.replace("{" + (i - 1) + "}", value.toString());
            }
            if (text != null) {
                if (!text.equals(methodCallExpression.getText())) {
                    text = text.replace("''", "'");
                }
                return text.length() > 50 ? text.substring(0, 47) + "...\"" : text;
            }
        }
        return methodCallExpression.getText();
    }

    private static String getI18nMessage(Project project, PsiLiteralExpression literal) {
        IProperty property = PropertyFoldingBuilder.getI18nProperty(project, literal);
        return property == null ? literal.getText() : PropertyFoldingBuilder.formatI18nProperty(literal, property);
    }

    private static IProperty getI18nProperty(Project project, PsiLiteralExpression literal) {
        Property property = (Property)literal.getUserData(CACHE);
        if (property == NULL) {
            return null;
        }
        if (property != null && PropertyFoldingBuilder.isValid(property, literal)) {
            return property;
        }
        if (PropertyFoldingBuilder.isI18nProperty(project, literal)) {
            PsiReference[] references;
            for (PsiReference reference : references = literal.getReferences()) {
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof IProperty)) continue;
                        IProperty p = (IProperty)element;
                        literal.putUserData(CACHE, (Object)p);
                        return p;
                    }
                    continue;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof IProperty)) continue;
                IProperty p = (IProperty)element;
                literal.putUserData(CACHE, (Object)p);
                return p;
            }
        }
        return null;
    }

    private static boolean isValid(Property property, PsiLiteralExpression literal) {
        if (literal == null || property == null || !property.isValid()) {
            return false;
        }
        return StringUtil.unquoteString((String)literal.getText()).equals(property.getKey());
    }

    private static String formatI18nProperty(PsiLiteralExpression literal, IProperty property) {
        return property == null ? literal.getText() : "\"" + property.getValue() + "\"";
    }

    public boolean isCollapsedByDefault(ASTNode node) {
        return PropertyFoldingBuilder.isFoldingsOn();
    }

    public static boolean isI18nProperty(Project project, PsiLiteralExpression expr) {
        if (!PropertyFoldingBuilder.isStringLiteral(expr)) {
            return false;
        }
        IProperty property = (IProperty)expr.getUserData(CACHE);
        if (property == NULL) {
            return false;
        }
        if (property != null) {
            return true;
        }
        HashMap<String, Object> annotationParams = new HashMap<String, Object>();
        annotationParams.put("resourceBundle", null);
        boolean isI18n = JavaI18nUtil.mustBePropertyKey(project, (PsiExpression)expr, annotationParams);
        if (!isI18n) {
            expr.putUserData(CACHE, (Object)NULL);
        }
        return isI18n;
    }

    private static boolean isStringLiteral(PsiLiteralExpression expr) {
        String text;
        if (expr == null || (text = expr.getText()) == null) {
            return false;
        }
        return text.startsWith("\"") && text.endsWith("\"") && text.length() > 2;
    }
}

