/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.palette;

import org.apache.sanselan.palette.Palette;
import org.apache.sanselan.util.Debug;

public class SimplePalette
extends Palette {
    private final int[] palette;

    public SimplePalette(int[] palette) {
        this.palette = palette;
    }

    @Override
    public int getPaletteIndex(int rgb) {
        return this.getPaletteIndex(this.palette, rgb);
    }

    @Override
    public int getEntry(int index) {
        return this.palette[index];
    }

    private int getPaletteIndex(int[] palette, int argb) {
        for (int i = 0; i < palette.length; ++i) {
            if (palette[i] != argb) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void dump() {
        for (int i = 0; i < this.palette.length; ++i) {
            Debug.debug("\tpalette[" + i + "]", this.palette[i] + " (0x" + Integer.toHexString(this.palette[i]) + ")");
        }
    }

    @Override
    public int length() {
        return this.palette.length;
    }
}

