/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.psd.dataparsers;

import org.apache.sanselan.formats.psd.ImageContents;
import org.apache.sanselan.formats.psd.dataparsers.DataParser;

public class DataParserIndexed
extends DataParser {
    private final int[] ColorTable = new int[256];

    public DataParserIndexed(byte[] ColorModeData) {
        for (int i = 0; i < 256; ++i) {
            int rgb;
            int red = 0xFF & ColorModeData[0 + i];
            int green = 0xFF & ColorModeData[256 + i];
            int blue = 0xFF & ColorModeData[512 + i];
            int alpha = 255;
            this.ColorTable[i] = rgb = (0xFF & alpha) << 24 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        }
    }

    @Override
    protected int getRGB(int[][][] data, int x, int y, ImageContents imageContents) {
        int sample = 0xFF & data[0][y][x];
        int rgb = this.ColorTable[sample];
        return rgb;
    }

    @Override
    public int getBasicChannelsCount() {
        return 1;
    }
}

