/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.png.BitParser;
import org.apache.sanselan.formats.png.GammaCorrection;
import org.apache.sanselan.formats.png.ScanExpediter;
import org.apache.sanselan.formats.png.chunks.PNGChunkPLTE;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilter;

public class ScanExpediterSimple
extends ScanExpediter {
    public ScanExpediterSimple(int width, int height, InputStream is, BufferedImage bi, int color_type, int BitDepth, int bitsPerPixel, PNGChunkPLTE pngChunkPLTE, GammaCorrection gammaCorrection, TransparencyFilter transparencyFilter) {
        super(width, height, is, bi, color_type, BitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, transparencyFilter);
    }

    @Override
    public void drive() throws ImageReadException, IOException {
        int bitsPerScanLine = this.bitsPerPixel * this.width;
        int pixelBytesPerScanLine = this.getBitsToBytesRoundingUp(bitsPerScanLine);
        byte[] prev = null;
        for (int y = 0; y < this.height; ++y) {
            byte[] unfiltered;
            prev = unfiltered = this.getNextScanline(this.is, pixelBytesPerScanLine, prev, this.bytesPerPixel);
            BitParser bitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
            for (int x = 0; x < this.width; ++x) {
                int rgb = this.getRGB(bitParser, x);
                this.bi.setRGB(x, y, rgb);
            }
        }
    }
}

