/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultTextHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.TextHeaders;
import io.netty.handler.codec.http.HttpHeaderDateFormat;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private static final int HIGHEST_INVALID_NAME_CHAR_MASK = -64;
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -16;
    private static final byte[] LOOKUP_TABLE = new byte[64];
    private final TextHeaders headers;
    private static final HttpHeadersValidationConverter VALIDATE_OBJECT_CONVERTER;
    private static final HttpHeadersValidationConverter NO_VALIDATE_OBJECT_CONVERTER;
    private static final HttpHeadersNameConverter VALIDATE_NAME_CONVERTER;
    private static final HttpHeadersNameConverter NO_VALIDATE_NAME_CONVERTER;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean validate) {
        this(true, validate ? VALIDATE_NAME_CONVERTER : NO_VALIDATE_NAME_CONVERTER);
    }

    protected DefaultHttpHeaders(boolean validate, DefaultHeaders.NameConverter<CharSequence> nameConverter) {
        this.headers = new DefaultTextHeaders(true, validate ? VALIDATE_OBJECT_CONVERTER : NO_VALIDATE_OBJECT_CONVERTER, nameConverter);
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.add(headers);
    }

    @Override
    public HttpHeaders set(HttpHeaders headers) {
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.set(headers);
    }

    @Override
    public HttpHeaders add(String name, Object value) {
        this.headers.addObject((CharSequence)name, value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Object value) {
        this.headers.addObject(name, value);
        return this;
    }

    @Override
    public HttpHeaders add(String name, Iterable<?> values) {
        this.headers.addObject((CharSequence)name, values);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        this.headers.addObject(name, values);
        return this;
    }

    @Override
    public HttpHeaders addInt(CharSequence name, int value) {
        this.headers.addInt(name, value);
        return this;
    }

    @Override
    public HttpHeaders addShort(CharSequence name, short value) {
        this.headers.addShort(name, value);
        return this;
    }

    @Override
    public HttpHeaders remove(String name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public HttpHeaders set(String name, Object value) {
        this.headers.setObject((CharSequence)name, value);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Object value) {
        this.headers.setObject(name, value);
        return this;
    }

    @Override
    public HttpHeaders set(String name, Iterable<?> values) {
        this.headers.setObject((CharSequence)name, values);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        this.headers.setObject(name, values);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence name, int value) {
        this.headers.setInt(name, value);
        return this;
    }

    @Override
    public HttpHeaders setShort(CharSequence name, short value) {
        this.headers.setShort(name, value);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String name) {
        return (String)this.headers.getAndConvert(name);
    }

    @Override
    public String get(CharSequence name) {
        return (String)this.headers.getAndConvert(name);
    }

    @Override
    public Integer getInt(CharSequence name) {
        return this.headers.getInt(name);
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        return this.headers.getInt(name, defaultValue);
    }

    @Override
    public Short getShort(CharSequence name) {
        return this.headers.getShort(name);
    }

    @Override
    public short getShort(CharSequence name, short defaultValue) {
        return this.headers.getInt(name, defaultValue);
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        return this.headers.getTimeMillis(name);
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        return this.headers.getTimeMillis(name, defaultValue);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAllAndConvert(name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.getAllAndConvert(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.headers.entriesConverted();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.headers.iteratorConverted();
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.headers.contains(name, value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.headers.contains(name, value, ignoreCase);
    }

    @Override
    public Map.Entry<CharSequence, CharSequence> forEachEntry(Headers.EntryVisitor<CharSequence> visitor) throws Exception {
        return this.headers.forEachEntry(visitor);
    }

    @Override
    public Set<String> names() {
        return this.headers.namesAndConvert(String.CASE_INSENSITIVE_ORDER);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttpHeaders)) {
            return false;
        }
        DefaultHttpHeaders other = (DefaultHttpHeaders)o;
        return this.headers.equals(other.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    void encode(ByteBuf buf) throws Exception {
        this.headers.forEachEntry(new HttpHeadersEncoder(buf));
    }

    static {
        DefaultHttpHeaders.LOOKUP_TABLE[9] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[10] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[11] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[12] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[32] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[44] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[58] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[59] = -1;
        DefaultHttpHeaders.LOOKUP_TABLE[61] = -1;
        VALIDATE_OBJECT_CONVERTER = new HttpHeadersValidationConverter(true);
        NO_VALIDATE_OBJECT_CONVERTER = new HttpHeadersValidationConverter(false);
        VALIDATE_NAME_CONVERTER = new HttpHeadersNameConverter(true);
        NO_VALIDATE_NAME_CONVERTER = new HttpHeadersNameConverter(false);
    }

    static class HttpHeadersNameConverter
    implements DefaultHeaders.NameConverter<CharSequence> {
        protected final boolean validate;

        HttpHeadersNameConverter(boolean validate) {
            this.validate = validate;
        }

        @Override
        public CharSequence convertName(CharSequence name) {
            if (this.validate) {
                if (name instanceof AsciiString) {
                    HttpHeadersNameConverter.validateName((AsciiString)name);
                } else {
                    HttpHeadersNameConverter.validateName(name);
                }
            }
            return name;
        }

        private static void validateName(AsciiString name) {
            int start = name.arrayOffset();
            int end = start + name.length();
            byte[] array = name.array();
            for (int index = start; index < end; ++index) {
                byte b = array[index];
                if (b < 0) {
                    throw new IllegalArgumentException("a header name cannot contain non-ASCII characters: " + name);
                }
                HttpHeadersNameConverter.validateNameChar(name, b);
            }
        }

        private static void validateName(CharSequence name) {
            for (int index = 0; index < name.length(); ++index) {
                char character = name.charAt(index);
                if (character > '\u007f') {
                    throw new IllegalArgumentException("a header name cannot contain non-ASCII characters: " + name);
                }
                HttpHeadersNameConverter.validateNameChar(name, character);
            }
        }

        private static void validateNameChar(CharSequence name, int character) {
            if ((character & 0xFFFFFFC0) == 0 && LOOKUP_TABLE[character] != 0) {
                throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
            }
        }
    }

    private static final class HttpHeadersValidationConverter
    extends DefaultTextHeaders.DefaultTextValueTypeConverter {
        private final boolean validate;

        HttpHeadersValidationConverter(boolean validate) {
            this.validate = validate;
        }

        @Override
        public CharSequence convertObject(Object value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            CharSequence seq = value instanceof CharSequence ? (CharSequence)value : (value instanceof Number ? value.toString() : (value instanceof Date ? HttpHeaderDateFormat.get().format((Date)value) : (value instanceof Calendar ? HttpHeaderDateFormat.get().format(((Calendar)value).getTime()) : value.toString())));
            if (this.validate) {
                if (value instanceof AsciiString) {
                    HttpHeadersValidationConverter.validateValue((AsciiString)seq);
                } else {
                    HttpHeadersValidationConverter.validateValue(seq);
                }
            }
            return seq;
        }

        private static void validateValue(AsciiString seq) {
            int state = 0;
            int start = seq.arrayOffset();
            int end = start + seq.length();
            byte[] array = seq.array();
            for (int index = start; index < end; ++index) {
                state = HttpHeadersValidationConverter.validateValueChar(seq, state, (char)(array[index] & 0xFF));
            }
            if (state != 0) {
                throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
            }
        }

        private static void validateValue(CharSequence seq) {
            int state = 0;
            for (int index = 0; index < seq.length(); ++index) {
                state = HttpHeadersValidationConverter.validateValueChar(seq, state, seq.charAt(index));
            }
            if (state != 0) {
                throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
            }
        }

        private static int validateValueChar(CharSequence seq, int state, char character) {
            if ((character & 0xFFFFFFF0) == 0) {
                switch (character) {
                    case '\u000b': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + seq);
                    }
                    case '\f': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + seq);
                    }
                }
            }
            block4 : switch (state) {
                case 0: {
                    switch (character) {
                        case '\r': {
                            state = 1;
                            break;
                        }
                        case '\n': {
                            state = 2;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (character) {
                        case '\n': {
                            state = 2;
                            break block4;
                        }
                    }
                    throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + seq);
                }
                case 2: {
                    switch (character) {
                        case '\t': 
                        case ' ': {
                            state = 0;
                            break block4;
                        }
                    }
                    throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + seq);
                }
            }
            return state;
        }
    }
}

