/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.jar.JarOutputStream;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidAarDepsBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidAarDepsBuildTarget> {
    private static final String BUILDER_NAME = "Android AAR Dependencies Packaging";

    public AndroidAarDepsBuilder() {
        super(Collections.singleton(AndroidAarDepsBuildTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(AndroidAarDepsBuildTarget target, DirtyFilesHolder<BuildRootDescriptor, AndroidAarDepsBuildTarget> holder, BuildOutputConsumer outputConsumer, CompileContext context) throws ProjectBuildException, IOException {
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            return;
        }
        assert (!AndroidJpsUtil.isLightBuild(context));
        if (!AndroidAarDepsBuilder.doBuild(context, target, outputConsumer)) {
            throw new StopBuildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doBuild(CompileContext context, AndroidAarDepsBuildTarget target, BuildOutputConsumer outputConsumer) {
        JpsModule module = target.getModule();
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null || extension.isLibrary()) {
            return true;
        }
        File outputDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
        if ((outputDir = AndroidJpsUtil.createDirIfNotExist(outputDir, context, BUILDER_NAME)) == null) {
            return false;
        }
        ArrayList<String> srcJarFiles = new ArrayList<String>();
        for (BuildRootDescriptor descriptor : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context)) {
            File file = descriptor.getRootFile();
            if (!file.exists()) continue;
            srcJarFiles.add(file.getPath());
        }
        if (srcJarFiles.size() == 0) {
            return true;
        }
        context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.aar.dependencies.packaging", module.getName())));
        File tempDir = null;
        try {
            tempDir = FileUtil.createTempDirectory((String)"extracted_aar_deps", (String)"tmp");
            for (int i = srcJarFiles.size() - 1; i >= 0; --i) {
                ZipUtil.extract((File)new File((String)srcJarFiles.get(i)), (File)tempDir, null, (boolean)true);
            }
            File outputJarFile = new File(outputDir, "aar_deps.jar");
            if (!AndroidAarDepsBuilder.packDirectoryIntoJar(tempDir, outputJarFile, context)) {
                boolean file = false;
                return file;
            }
            AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
            if (testingManager != null && outputJarFile.isFile()) {
                testingManager.getCommandExecutor().checkJarContent("aar_dependencies_package_jar", outputJarFile.getPath());
            }
            outputConsumer.registerOutputFile(outputJarFile, srcJarFiles);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempDir != null) {
                FileUtil.delete((File)tempDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean packDirectoryIntoJar(final File srcDir, File dstJar, final CompileContext context) throws IOException {
        final JarOutputStream jos = new JarOutputStream(new FileOutputStream(dstJar));
        try {
            boolean bl = FileUtil.processFilesRecursively((File)srcDir, (Processor)new Processor<File>(){

                public boolean process(File file) {
                    String relPath;
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"class") && (relPath = FileUtil.getRelativePath((File)srcDir, (File)file)) != null) {
                        try {
                            AndroidCommonUtils.packIntoJar((JarOutputStream)jos, (File)file, (String)relPath);
                        }
                        catch (IOException e) {
                            AndroidJpsUtil.reportExceptionError(context, null, e, AndroidAarDepsBuilder.BUILDER_NAME);
                            return false;
                        }
                    }
                    return true;
                }
            });
            return bl;
        }
        finally {
            jos.close();
        }
    }

    public String getPresentableName() {
        return BUILDER_NAME;
    }
}

