/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPackagingStateStorage;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidResourcePackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourcePackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidResourcePackagingBuildTarget> {
    private static final String BUILDER_NAME = "Android Resource Packaging";

    protected AndroidResourcePackagingBuilder() {
        super(Collections.singletonList(AndroidResourcePackagingBuildTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(AndroidResourcePackagingBuildTarget target, DirtyFilesHolder<BuildRootDescriptor, AndroidResourcePackagingBuildTarget> holder, BuildOutputConsumer outputConsumer, CompileContext context) throws ProjectBuildException, IOException {
        AndroidPackagingStateStorage.MyState savedState;
        boolean releaseBuild = AndroidJpsUtil.isReleaseBuild(context);
        AndroidPackagingStateStorage packagingStateStorage = (AndroidPackagingStateStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)target, (StorageProvider)AndroidPackagingStateStorage.Provider.INSTANCE);
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles() && (savedState = packagingStateStorage.read()) != null && savedState.isRelease() == releaseBuild) {
            return;
        }
        assert (!AndroidJpsUtil.isLightBuild(context));
        if (!AndroidResourcePackagingBuilder.packageResources(target, context, outputConsumer, releaseBuild)) {
            throw new StopBuildException();
        }
        packagingStateStorage.saveState(new AndroidPackagingStateStorage.MyState(releaseBuild));
    }

    public String getPresentableName() {
        return BUILDER_NAME;
    }

    private static boolean packageResources(AndroidResourcePackagingBuildTarget target, CompileContext context, BuildOutputConsumer outputConsumer, boolean releaseBuild) {
        JpsModule module = target.getModule();
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        assert (extension != null && !extension.isLibrary());
        context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.packaging.resources", module.getName())));
        File manifestFile = AndroidJpsUtil.getPreprocessedManifestFile(extension, context.getProjectDescriptor().dataManager.getDataPaths());
        if (manifestFile == null || !manifestFile.exists()) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.manifest.not.found", module.getName())));
            return false;
        }
        ArrayList<String> assetsDirPaths = new ArrayList<String>();
        AndroidResourcePackagingBuildTarget.collectAssetDirs(extension, assetsDirPaths, true);
        String outputFilePath = target.getOutputFile(context).getPath();
        File outputDir = new File(outputFilePath).getParentFile();
        assert (outputDir != null);
        if ((outputDir = AndroidJpsUtil.createDirIfNotExist(outputDir, context, BUILDER_NAME)) == null) {
            return false;
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        IAndroidTarget androidTarget = platform.getTarget();
        String[] resourceDirPaths = AndroidJpsUtil.collectResourceDirsForCompilation(extension, true, context, true);
        String customManifestPackage = extension.isUseCustomManifestPackage() ? extension.getCustomManifestPackage() : null;
        String additionalParameters = extension.getAdditionalPackagingCommandLineParameters();
        return AndroidResourcePackagingBuilder.doPackageResources(context, manifestFile, androidTarget, resourceDirPaths, ArrayUtil.toStringArray(assetsDirPaths), outputFilePath, releaseBuild, module.getName(), outputConsumer, customManifestPackage, additionalParameters);
    }

    private static boolean doPackageResources(CompileContext context, File manifestFile, IAndroidTarget target, String[] resourceDirPaths, String[] assetsDirPaths, String outputPath, boolean releasePackage, String moduleName, BuildOutputConsumer outputConsumer, String customManifestPackage, String additionalParameters) {
        try {
            boolean success;
            final IgnoredFileIndex ignoredFileIndex = context.getProjectDescriptor().getIgnoredFileIndex();
            Map messages = AndroidApt.packageResources((IAndroidTarget)target, (int)-1, (String)manifestFile.getPath(), (String[])resourceDirPaths, (String[])assetsDirPaths, (String)outputPath, null, (!releasePackage ? 1 : 0) != 0, (int)0, (String)customManifestPackage, (String)additionalParameters, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !ignoredFileIndex.isIgnored(PathUtilRt.getFileName((String)pathname.getPath()));
                }
            });
            AndroidJpsUtil.addMessages(context, messages, BUILDER_NAME, moduleName);
            boolean bl = success = ((List)messages.get(AndroidCompilerMessageKind.ERROR)).size() == 0;
            if (success) {
                ArrayList<String> srcFiles = new ArrayList<String>();
                srcFiles.add(manifestFile.getPath());
                AndroidResourcePackagingBuilder.fillRecursively(resourceDirPaths, srcFiles);
                AndroidResourcePackagingBuilder.fillRecursively(assetsDirPaths, srcFiles);
                outputConsumer.registerOutputFile(new File(outputPath), srcFiles);
            }
            return success;
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
            return false;
        }
    }

    private static void fillRecursively(String[] roots, final List<String> result) {
        for (String root : roots) {
            FileUtil.processFilesRecursively((File)new File(root), (Processor)new Processor<File>(){

                public boolean process(File file) {
                    if (file.isFile()) {
                        result.add(file.getPath());
                    }
                    return true;
                }
            });
        }
    }
}

