/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidManifestMergingTarget
extends ModuleBasedTarget<MyRootDescriptor> {
    public AndroidManifestMergingTarget(ModuleBasedBuildTargetType<?> targetType, JpsModule module) {
        super(targetType, module);
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    public boolean isTests() {
        return false;
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        BuildTargetType mavenResourcesProductionType = TargetTypeRegistry.getInstance().getTargetType("maven-resources-production");
        if (mavenResourcesProductionType != null) {
            return new ArrayList(targetRegistry.getAllTargets(mavenResourcesProductionType));
        }
        return Collections.emptyList();
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
    }

    public List<MyRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        ArrayList<MyRootDescriptor> result = new ArrayList<MyRootDescriptor>();
        File manifestFile = AndroidJpsUtil.getManifestFileForCompilationPath(extension);
        if (manifestFile != null) {
            result.add(new MyRootDescriptor((BuildTarget)this, manifestFile, false));
        }
        for (JpsAndroidModuleExtension libExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
            File libManifest = AndroidJpsUtil.getManifestFileForCompilationPath(libExtension);
            if (libManifest == null || !libManifest.exists()) continue;
            result.add(new MyRootDescriptor((BuildTarget)this, libManifest, true));
        }
        return result;
    }

    public MyRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MyRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    public String getPresentableName() {
        return "Android Manifest Merging";
    }

    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputDirectory(context));
    }

    public File getOutputDirectory(CompileContext context) {
        return AndroidJpsUtil.getPreprocessedManifestDirectory(this.myModule, context.getProjectDescriptor().dataManager.getDataPaths());
    }

    public static class MyRootDescriptor
    extends BuildRootDescriptorImpl {
        private final boolean myLibManifestRoot;

        private MyRootDescriptor(BuildTarget target, File root, boolean libManifestRoot) {
            super(target, root);
            this.myLibManifestRoot = libManifestRoot;
        }

        public boolean isLibManifestRoot() {
            return this.myLibManifestRoot;
        }
    }

    public static class MyTargetType
    extends ModuleBasedBuildTargetType<AndroidManifestMergingTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-manifest-merging");
        }

        public List<AndroidManifestMergingTarget> computeAllTargets(JpsModel model) {
            if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
                return Collections.emptyList();
            }
            ArrayList<AndroidManifestMergingTarget> targets = new ArrayList<AndroidManifestMergingTarget>();
            for (JpsModule module : model.getProject().getModules()) {
                JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
                if (extension == null || extension.isLibrary() || !extension.isManifestMergingEnabled()) continue;
                targets.add(new AndroidManifestMergingTarget(this, module));
            }
            return targets;
        }

        public BuildTargetLoader<AndroidManifestMergingTarget> createLoader(JpsModel model) {
            final HashMap<String, AndroidManifestMergingTarget> targetMap = new HashMap<String, AndroidManifestMergingTarget>();
            for (AndroidManifestMergingTarget target : this.computeAllTargets(model)) {
                targetMap.put(target.getId(), target);
            }
            return new BuildTargetLoader<AndroidManifestMergingTarget>(){

                public AndroidManifestMergingTarget createTarget(String targetId) {
                    return (AndroidManifestMergingTarget)((Object)targetMap.get(targetId));
                }
            };
        }
    }
}

