/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.local.LocalSdk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.OrderedSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.AndroidBuildDataCache;
import org.jetbrains.jps.android.AndroidDependencyProcessor;
import org.jetbrains.jps.android.AndroidDependencyType;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.ProGuardOptions;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.model.AndroidApplicationArtifactType;
import org.jetbrains.jps.android.model.JpsAndroidApplicationArtifactProperties;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidFinalPackageElement;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumerationHandler;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class AndroidJpsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidJpsUtil");
    public static final String ANDROID_FACET_TYPE_ID = "android";
    public static final String ANDROID_FACET_NAME = "Android";
    public static final String ANDROID_STORAGE_DIR = "android";
    private static final String RESOURCE_CACHE_STORAGE = "res_cache";
    private static final String INTERMEDIATE_ARTIFACTS_STORAGE = "intermediate_artifacts";
    public static final String GENERATED_RESOURCES_DIR_NAME = "generated_resources";
    public static final String AAPT_GENERATED_SOURCE_ROOT_NAME = "aapt";
    public static final String AIDL_GENERATED_SOURCE_ROOT_NAME = "aidl";
    public static final String RENDERSCRIPT_GENERATED_SOURCE_ROOT_NAME = "rs";
    public static final String BUILD_CONFIG_GENERATED_SOURCE_ROOT_NAME = "build_config";
    private static final String GENERATED_SOURCES_FOLDER_NAME = "generated_sources";
    private static final String PREPROCESSED_MANIFEST_FOLDER_NAME = "preprocessed_manifest";
    private static final String COPIED_SOURCES_FOLDER_NAME = "copied_sources";
    private static final String MANIFEST_TAG = "manifest";

    private AndroidJpsUtil() {
    }

    public static boolean shouldProcessDependenciesRecursively(JpsModule module) {
        return JpsJavaDependenciesEnumerationHandler.shouldProcessDependenciesRecursively((List)JpsJavaDependenciesEnumerationHandler.createHandlers(Collections.singletonList(module)));
    }

    public static File getMainContentRoot(JpsAndroidModuleExtension extension) throws IOException {
        JpsModule module = extension.getModule();
        List contentRoots = module.getContentRootsList().getUrls();
        if (contentRoots.size() == 0) {
            return null;
        }
        File manifestFile = extension.getManifestFile();
        if (manifestFile != null) {
            for (String rootUrl : contentRoots) {
                File root = JpsPathUtil.urlToFile((String)rootUrl);
                if (!FileUtil.isAncestor((File)root, (File)manifestFile, (boolean)true)) continue;
                return root;
            }
        }
        return JpsPathUtil.urlToFile((String)((String)contentRoots.get(0)));
    }

    public static void addMessages(CompileContext context, Map<AndroidCompilerMessageKind, List<String>> messages, String builderName, String entryName) {
        for (Map.Entry<AndroidCompilerMessageKind, List<String>> entry : messages.entrySet()) {
            for (String message : entry.getValue()) {
                BuildMessage.Kind category;
                String filePath = null;
                int line = -1;
                Matcher matcher = AndroidCommonUtils.COMPILER_MESSAGE_PATTERN.matcher(message);
                if (matcher.matches()) {
                    filePath = matcher.group(1);
                    line = Integer.parseInt(matcher.group(2));
                }
                if ((category = AndroidJpsUtil.toBuildMessageKind(entry.getKey())) == null) continue;
                context.processMessage((BuildMessage)new CompilerMessage(builderName, category, '[' + entryName + "] " + message, filePath, -1L, -1L, -1L, (long)line, -1L));
            }
        }
    }

    public static JpsAndroidModuleExtension getExtension(JpsModule module) {
        return (JpsAndroidModuleExtension)module.getContainer().getChild(JpsAndroidModuleExtensionImpl.KIND);
    }

    public static String[] toPaths(File[] files) {
        String[] result = new String[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = files[i].getPath();
        }
        return result;
    }

    public static List<String> toPaths(Collection<File> files) {
        if (files.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(files.size());
        for (File file : files) {
            result.add(file.getPath());
        }
        return result;
    }

    public static File getDirectoryForIntermediateArtifacts(CompileContext context, JpsModule module) {
        return AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context.getProjectDescriptor().dataManager.getDataPaths(), module);
    }

    public static File getDirectoryForIntermediateArtifacts(BuildDataPaths dataPaths, JpsModule module) {
        return new File(AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths), module.getName());
    }

    public static File getDirectoryForIntermediateArtifacts(BuildDataPaths dataPaths) {
        File androidStorage = new File(dataPaths.getDataStorageRoot(), "android");
        return new File(androidStorage, INTERMEDIATE_ARTIFACTS_STORAGE);
    }

    public static File createDirIfNotExist(File dir, CompileContext context, String compilerName) {
        if (!dir.exists() && !dir.mkdirs()) {
            context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", dir.getPath())));
            return null;
        }
        return dir;
    }

    public static void addSubdirectories(File baseDir, Collection<String> result) {
        File[] children = baseDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!child.isDirectory()) continue;
                result.add(child.getPath());
            }
        }
    }

    public static Set<String> getExternalLibraries(CompileContext context, JpsModule module, AndroidPlatform platform) {
        BuildDataPaths paths = context.getProjectDescriptor().dataManager.getDataPaths();
        return AndroidJpsUtil.getExternalLibraries(paths, module, platform, true, true, false);
    }

    public static Set<String> getExternalLibraries(BuildDataPaths paths, JpsModule module, AndroidPlatform platform, boolean resolveJars, boolean withAarDeps, boolean withPackagedAarDepsJar) {
        HashSet result = new HashSet();
        AndroidDependencyProcessor processor = new AndroidDependencyProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void processExternalLibrary(File file) {
                this.val$result.add(file.getPath());
            }

            @Override
            public boolean isToProcess(AndroidDependencyType type) {
                return type == AndroidDependencyType.EXTERNAL_LIBRARY;
            }
        };
        AndroidJpsUtil.processClasspath(paths, module, processor, resolveJars, withAarDeps);
        if (platform != null) {
            AndroidJpsUtil.addAnnotationsJarIfNecessary(platform, (Set<String>)result);
        }
        if (withPackagedAarDepsJar) {
            result.add(AndroidAarDepsBuildTarget.getOutputFile(module, paths).getPath());
        }
        return result;
    }

    public static Set<String> getProvidedLibraries(BuildDataPaths paths, JpsModule module) {
        HashSet result = new HashSet();
        AndroidJpsUtil.processClasspath(paths, module, new AndroidDependencyProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void processProvidedLibrary(File file) {
                this.val$result.add(file.getPath());
            }

            @Override
            public boolean isToProcess(AndroidDependencyType type) {
                return type == AndroidDependencyType.PROVIDED_LIBRARY;
            }
        }, false, false);
        return result;
    }

    private static void addAnnotationsJarIfNecessary(AndroidPlatform platform, Set<String> libs) {
        if (platform.needToAddAnnotationsJarToClasspath()) {
            String sdkHomePath = platform.getSdk().getHomePath();
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            libs.add(annotationsJarPath);
        }
    }

    public static void processClasspath(BuildDataPaths paths, JpsModule module, AndroidDependencyProcessor processor, boolean resolveJars, boolean withAarDeps) {
        boolean recursive = AndroidJpsUtil.shouldProcessDependenciesRecursively(module);
        AndroidJpsUtil.processClasspath(paths, module, processor, (Set<String>)new HashSet(), false, recursive, resolveJars, withAarDeps);
    }

    private static void processClasspath(BuildDataPaths paths, JpsModule module, final AndroidDependencyProcessor processor, Set<String> visitedModules, boolean exportedLibrariesOnly, boolean recursive, boolean resolveJars, boolean withAarDeps) {
        JpsLibrary library;
        if (!visitedModules.add(module.getName())) {
            return;
        }
        if (processor.isToProcess(AndroidDependencyType.EXTERNAL_LIBRARY)) {
            for (JpsDependencyElement item : JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, exportedLibrariesOnly)) {
                if (!(item instanceof JpsLibraryDependency) || (library = ((JpsLibraryDependency)item).getLibrary()) == null || !withAarDeps && AndroidJpsUtil.getResDirAndJarsIfAar(library) != null) continue;
                for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                    File file = JpsPathUtil.urlToFile((String)root.getUrl());
                    if (resolveJars) {
                        AndroidJpsUtil.processClassFilesAndJarsRecursively(file, new Processor<File>(){

                            public boolean process(File file) {
                                processor.processExternalLibrary(file);
                                return true;
                            }
                        });
                        continue;
                    }
                    processor.processExternalLibrary(file);
                }
            }
        }
        if (processor.isToProcess(AndroidDependencyType.PROVIDED_LIBRARY)) {
            for (JpsDependencyElement item : module.getDependenciesList().getDependencies()) {
                if (!(item instanceof JpsLibraryDependency)) continue;
                library = ((JpsLibraryDependency)item).getLibrary();
                JpsJavaDependencyExtension extension = JpsJavaExtensionService.getInstance().getDependencyExtension(item);
                if (library == null || extension == null || extension.getScope() != JpsJavaDependencyScope.PROVIDED) continue;
                for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                    processor.processProvidedLibrary(JpsPathUtil.urlToFile((String)root.getUrl()));
                }
            }
        }
        for (JpsDependencyElement item : JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, false)) {
            JpsModule depModule;
            if (!(item instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)item).getModule()) == null) continue;
            JpsAndroidModuleExtension depExtension = AndroidJpsUtil.getExtension(depModule);
            boolean depLibrary = depExtension != null && depExtension.isLibrary();
            File depClassDir = new ModuleBuildTarget(depModule, JavaModuleBuildTargetType.PRODUCTION).getOutputDir();
            if (depLibrary) {
                if (processor.isToProcess(AndroidDependencyType.ANDROID_LIBRARY_PACKAGE)) {
                    File intArtifactsDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(paths, depModule);
                    File packagedClassesJar = new File(intArtifactsDir, "classes.jar");
                    processor.processAndroidLibraryPackage(packagedClassesJar, depModule);
                }
                if (processor.isToProcess(AndroidDependencyType.ANDROID_LIBRARY_OUTPUT_DIRECTORY) && depClassDir != null) {
                    processor.processAndroidLibraryOutputDirectory(depClassDir);
                }
            } else if (processor.isToProcess(AndroidDependencyType.JAVA_MODULE_OUTPUT_DIR) && depExtension == null && depClassDir != null) {
                processor.processJavaModuleOutputDirectory(depClassDir);
            }
            if (!recursive) continue;
            boolean newRecursive = AndroidJpsUtil.shouldProcessDependenciesRecursively(depModule);
            AndroidJpsUtil.processClasspath(paths, depModule, processor, visitedModules, !depLibrary || exportedLibrariesOnly, newRecursive, resolveJars, withAarDeps);
        }
    }

    public static void processClassFilesAndJarsRecursively(File root, final Processor<File> processor) {
        FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String fileName;
                return !file.isFile() || !FileUtilRt.extensionEquals((String)(fileName = file.getName()), (String)"jar") && !FileUtilRt.extensionEquals((String)fileName, (String)"class") || processor.process((Object)file);
            }
        });
    }

    public static Pair<IAndroidTarget, LocalSdk> getAndroidTarget(JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, CompileContext context, String builderName) {
        JpsAndroidSdkProperties sdkProperties = (JpsAndroidSdkProperties)((JpsSimpleElement)sdk.getSdkProperties()).getData();
        String targetHashString = sdkProperties.getBuildTargetHashString();
        if (targetHashString == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, "Cannot parse SDK " + sdk.getParent().getName() + ": build target is not specified"));
            }
            return null;
        }
        LocalSdk localSdk = AndroidBuildDataCache.getInstance().getSdk(new File(sdk.getHomePath()));
        IAndroidTarget target = localSdk.getTargetFromHashString(targetHashString);
        if (target == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, "Cannot parse SDK '" + sdk.getParent().getName() + "': unknown target " + targetHashString));
            }
            return null;
        }
        return Pair.create((Object)target, (Object)localSdk);
    }

    public static BuildMessage.Kind toBuildMessageKind(AndroidCompilerMessageKind kind) {
        switch (kind) {
            case ERROR: {
                return BuildMessage.Kind.ERROR;
            }
            case INFORMATION: {
                return BuildMessage.Kind.INFO;
            }
            case WARNING: {
                return BuildMessage.Kind.WARNING;
            }
        }
        LOG.error("unknown AndroidCompilerMessageKind object " + kind);
        return null;
    }

    public static void reportExceptionError(CompileContext context, String filePath, Exception exception, String builderName) {
        String message = exception.getMessage();
        if (message != null) {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, message, filePath));
            LOG.debug((Throwable)exception);
        } else {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, (Throwable)exception));
        }
    }

    public static ModuleLevelBuilder.ExitCode handleException(CompileContext context, Exception e, String builderName, Logger logger) throws ProjectBuildException {
        if (logger != null) {
            logger.info((Throwable)e);
        }
        context.processMessage((BuildMessage)new CompilerMessage(builderName, (Throwable)e));
        throw new StopBuildException();
    }

    public static File getManifestFileForCompilationPath(JpsAndroidModuleExtension extension) {
        return extension.useCustomManifestForCompilation() ? extension.getManifestFileForCompilation() : extension.getManifestFile();
    }

    public static AndroidPlatform getAndroidPlatform(JpsModule module, CompileContext context, String builderName) {
        JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
        if (sdk == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.sdk.not.specified", module.getName())));
            }
            return null;
        }
        Pair<IAndroidTarget, LocalSdk> pair = AndroidJpsUtil.getAndroidTarget((JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>>)sdk, context, builderName);
        if (pair == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.sdk.invalid", module.getName())));
            }
            return null;
        }
        return new AndroidPlatform((JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>>)sdk, (IAndroidTarget)pair.getFirst(), (LocalSdk)pair.getSecond());
    }

    public static String[] collectResourceDirsForCompilation(JpsAndroidModuleExtension extension, boolean withCacheDirs, CompileContext context, boolean checkExistence) {
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        return AndroidJpsUtil.collectResourceDirsForCompilation(extension, withCacheDirs, dataPaths, checkExistence);
    }

    public static String[] collectResourceDirsForCompilation(JpsAndroidModuleExtension extension, boolean withCacheDirs, BuildDataPaths dataPaths, boolean checkExistence) {
        OrderedSet result = new OrderedSet();
        AndroidJpsUtil.addCompilableResourceDirsForModule(extension, withCacheDirs, dataPaths, (Collection<String>)result, checkExistence);
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
            AndroidJpsUtil.addCompilableResourceDirsForModule(depExtension, withCacheDirs, dataPaths, (Collection<String>)result, checkExistence);
        }
        return ArrayUtil.toStringArray((Collection)result);
    }

    private static void addCompilableResourceDirsForModule(JpsAndroidModuleExtension extension, boolean withCacheDirs, BuildDataPaths dataPaths, Collection<String> result, boolean checkExistence) {
        if (withCacheDirs) {
            File resourcesCacheDir = AndroidJpsUtil.getResourcesCacheDir(extension.getModule(), dataPaths);
            if (!checkExistence || resourcesCacheDir.exists()) {
                result.add(resourcesCacheDir.getPath());
            }
        }
        for (File resOverlayDir : extension.getResourceOverlayDirs()) {
            if (resOverlayDir == null || checkExistence && !resOverlayDir.exists()) continue;
            result.add(resOverlayDir.getPath());
        }
        File resDir = AndroidJpsUtil.getResourceDirForCompilationPath(extension);
        if (resDir != null && (!checkExistence || resDir.exists())) {
            result.add(resDir.getPath());
        }
        File generatedResourcesStorage = AndroidJpsUtil.getGeneratedResourcesStorage(extension.getModule(), dataPaths);
        if (!checkExistence || generatedResourcesStorage.exists()) {
            result.add(generatedResourcesStorage.getPath());
        }
        AndroidJpsUtil.collectResDirectoriesFromAarDeps(extension.getModule(), result);
    }

    public static File getResourceDirForCompilationPath(JpsAndroidModuleExtension extension) {
        return extension.useCustomResFolderForCompilation() ? extension.getResourceDirForCompilation() : extension.getResourceDir();
    }

    public static List<JpsAndroidModuleExtension> getAllAndroidDependencies(JpsModule module, boolean librariesOnly) {
        return AndroidBuildDataCache.getInstance().getAllAndroidDependencies(module, librariesOnly);
    }

    public static boolean isLightBuild(CompileContext context) {
        String typeId = AndroidJpsUtil.getRunConfigurationTypeId(context);
        return typeId != null && AndroidCommonUtils.isTestConfiguration((String)typeId);
    }

    public static String getRunConfigurationTypeId(CompileContext context) {
        return context.getBuilderParameter("RUN_CONFIGURATION_TYPE_ID");
    }

    public static boolean isReleaseBuild(CompileContext context) {
        if (Boolean.parseBoolean(context.getBuilderParameter("RELEASE_BUILD_KEY"))) {
            return true;
        }
        for (JpsArtifact artifact : AndroidJpsUtil.getAndroidArtifactsToBuild(context)) {
            AndroidArtifactSigningMode signingMode;
            JpsElement props = artifact.getProperties();
            if (!(props instanceof JpsAndroidApplicationArtifactProperties) || (signingMode = ((JpsAndroidApplicationArtifactProperties)props).getSigningMode()) == AndroidArtifactSigningMode.DEBUG || signingMode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) continue;
            return true;
        }
        return false;
    }

    public static List<JpsArtifact> getAndroidArtifactsToBuild(CompileContext context) {
        List artifacts = JpsArtifactService.getInstance().getArtifacts(context.getProjectDescriptor().getProject());
        ArrayList<JpsArtifact> result = new ArrayList<JpsArtifact>();
        for (JpsArtifact artifact : artifacts) {
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !context.getScope().isAffected((BuildTarget)new ArtifactBuildTarget(artifact))) continue;
            result.add(artifact);
        }
        return result;
    }

    public static File getResourcesCacheDir(JpsModule module, BuildDataPaths dataPaths) {
        File androidStorage = new File(dataPaths.getDataStorageRoot(), "android");
        return new File(new File(androidStorage, RESOURCE_CACHE_STORAGE), module.getName());
    }

    public static File[] getSourceRootsForModuleAndDependencies(JpsModule rootModule) {
        HashSet result = new HashSet();
        for (JpsModule module : AndroidJpsUtil.getRuntimeModuleDeps(rootModule)) {
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            File resDir = null;
            File resDirForCompilation = null;
            if (extension != null) {
                resDir = extension.getResourceDir();
                resDirForCompilation = extension.getResourceDirForCompilation();
            }
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                File rootDir = JpsPathUtil.urlToFile((String)root.getUrl());
                if (!JavaSourceRootType.SOURCE.equals(root.getRootType()) && (!JavaSourceRootType.TEST_SOURCE.equals(root.getRootType()) || extension == null || !extension.isPackTestCode()) || FileUtil.filesEqual((File)rootDir, (File)resDir) || rootDir.equals(resDirForCompilation)) continue;
                result.add(rootDir);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    public static File[] getJavaOutputRootsForModuleAndDependencies(JpsModule rootModule) {
        HashSet result = new HashSet();
        for (JpsModule module : AndroidJpsUtil.getRuntimeModuleDeps(rootModule)) {
            File testOutputDir;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            File outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(module, false);
            if (outputDir != null) {
                result.add(outputDir);
            }
            if (extension == null || !extension.isPackTestCode() || (testOutputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(module, true)) == null) continue;
            result.add(testOutputDir);
        }
        return result.toArray(new File[result.size()]);
    }

    private static Set<JpsModule> getRuntimeModuleDeps(JpsModule rootModule) {
        return JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singletonList(rootModule)).recursively().runtimeOnly().getModules();
    }

    public static String getApkPath(JpsAndroidModuleExtension extension, File outputDirForPackagedArtifacts) {
        String apkRelativePath = extension.getApkRelativePath();
        JpsModule module = extension.getModule();
        if (apkRelativePath == null || apkRelativePath.length() == 0) {
            return new File(outputDirForPackagedArtifacts, AndroidJpsUtil.getApkName(module)).getPath();
        }
        File moduleBaseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        return moduleBaseDirectory != null ? FileUtil.toSystemDependentName((String)(moduleBaseDirectory.getAbsolutePath() + apkRelativePath)) : null;
    }

    public static String getApkName(JpsModule module) {
        return module.getName() + ".apk";
    }

    public static File getGeneratedSourcesStorage(JpsModule module, BuildDataManager dataManager) {
        return AndroidJpsUtil.getGeneratedSourcesStorage(module, dataManager.getDataPaths());
    }

    public static File getGeneratedSourcesStorage(JpsModule module, BuildDataPaths dataPaths) {
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsUtil.getStorageDir(targetDataRoot, GENERATED_SOURCES_FOLDER_NAME);
    }

    public static File getPreprocessedManifestDirectory(JpsModule module, BuildDataPaths dataPaths) {
        File androidStorage = new File(dataPaths.getDataStorageRoot(), "android");
        return new File(new File(androidStorage, PREPROCESSED_MANIFEST_FOLDER_NAME), module.getName());
    }

    public static File getPreprocessedManifestFile(JpsAndroidModuleExtension extension, BuildDataPaths dataPaths) {
        if (extension.isLibrary() || !extension.isManifestMergingEnabled()) {
            return AndroidJpsUtil.getManifestFileForCompilationPath(extension);
        }
        File dir = AndroidJpsUtil.getPreprocessedManifestDirectory(extension.getModule(), dataPaths);
        return new File(dir, "AndroidManifest.xml");
    }

    public static File getCopiedSourcesStorage(JpsModule module, BuildDataPaths dataPaths) {
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsUtil.getStorageDir(targetDataRoot, COPIED_SOURCES_FOLDER_NAME);
    }

    public static File getGeneratedResourcesStorage(JpsModule module, BuildDataManager dataManager) {
        return AndroidJpsUtil.getGeneratedResourcesStorage(module, dataManager.getDataPaths());
    }

    private static File getGeneratedResourcesStorage(JpsModule module, BuildDataPaths dataPaths) {
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsUtil.getStorageDir(targetDataRoot, GENERATED_RESOURCES_DIR_NAME);
    }

    public static File getStorageFile(File dataStorageRoot, String storageName) {
        return new File(AndroidJpsUtil.getStorageDir(dataStorageRoot, storageName), storageName);
    }

    public static File getStorageDir(File dataStorageRoot, String storageName) {
        return new File(new File(dataStorageRoot, "android"), storageName);
    }

    private static Properties readPropertyFile(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
            return properties;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static Pair<String, File> getProjectPropertyValue(JpsAndroidModuleExtension extension, String propertyKey) {
        String value;
        Properties properties;
        File root;
        try {
            root = AndroidJpsUtil.getMainContentRoot(extension);
        }
        catch (IOException e) {
            return null;
        }
        if (root == null) {
            return null;
        }
        File projectProperties = new File(root, "project.properties");
        if (projectProperties.exists() && (properties = AndroidJpsUtil.readPropertyFile(projectProperties)) != null && (value = properties.getProperty(propertyKey)) != null) {
            return Pair.create((Object)value, (Object)projectProperties);
        }
        return null;
    }

    public static Set<String> getGenDirs(JpsAndroidModuleExtension extension) throws IOException {
        HashSet result = new HashSet();
        File dir = extension.getAaptGenDir();
        if (dir != null) {
            result.add(dir.getPath());
        }
        if ((dir = extension.getAidlGenDir()) != null) {
            result.add(dir.getPath());
        }
        return result;
    }

    public static JpsAndroidModuleExtension getPackagedFacet(JpsArtifact artifact) {
        List<JpsAndroidModuleExtension> facets = AndroidJpsUtil.getAllPackagedFacets(artifact);
        return facets.size() == 1 ? facets.get(0) : null;
    }

    public static List<JpsAndroidModuleExtension> getAllPackagedFacets(JpsArtifact artifact) {
        final ArrayList<JpsAndroidModuleExtension> extensions = new ArrayList<JpsAndroidModuleExtension>();
        JpsArtifactUtil.processPackagingElements((JpsPackagingElement)artifact.getRootElement(), (Processor)new Processor<JpsPackagingElement>(){

            public boolean process(JpsPackagingElement element) {
                if (element instanceof JpsAndroidFinalPackageElement) {
                    JpsAndroidModuleExtension extension;
                    JpsModuleReference reference = ((JpsAndroidFinalPackageElement)element).getModuleReference();
                    JpsModule module = reference != null ? (JpsModule)reference.resolve() : null;
                    JpsAndroidModuleExtension jpsAndroidModuleExtension = extension = module != null ? AndroidJpsUtil.getExtension(module) : null;
                    if (extension != null) {
                        extensions.add(extension);
                    }
                }
                return true;
            }
        });
        return extensions;
    }

    private static File[] toFiles(String[] paths) {
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]);
        }
        return files;
    }

    public static ProGuardOptions getProGuardConfigIfShouldRun(CompileContext context, JpsAndroidModuleExtension extension) throws IOException {
        String[] paths;
        if (extension.isRunProguard()) {
            return new ProGuardOptions(extension.getProguardConfigFiles(extension.getModule()));
        }
        String cfgPathsStrFromContext = context.getBuilderParameter("ANDROID_PROGUARD_CFG_PATHS");
        if (cfgPathsStrFromContext != null && cfgPathsStrFromContext.length() > 0 && (paths = cfgPathsStrFromContext.split(File.pathSeparator)).length > 0) {
            File[] files = AndroidJpsUtil.toFiles(paths);
            return new ProGuardOptions(Arrays.asList(files));
        }
        for (JpsArtifact artifact : AndroidJpsUtil.getAndroidArtifactsToBuild(context)) {
            JpsAndroidApplicationArtifactProperties androidProps;
            JpsElement props;
            JpsAndroidModuleExtension facetFromArtifact = AndroidJpsUtil.getPackagedFacet(artifact);
            JpsModule moduleFromArtifact = facetFromArtifact != null ? facetFromArtifact.getModule() : null;
            if (moduleFromArtifact == null || !moduleFromArtifact.equals(extension.getModule()) || !((props = artifact.getProperties()) instanceof JpsAndroidApplicationArtifactProperties) || !(androidProps = (JpsAndroidApplicationArtifactProperties)props).isRunProGuard()) continue;
            List<String> cfgFileUrls = androidProps.getProGuardCfgFiles(moduleFromArtifact);
            List<File> cfgPaths = cfgFileUrls != null ? AndroidJpsUtil.urlsToFiles(cfgFileUrls) : null;
            return new ProGuardOptions(cfgPaths);
        }
        return null;
    }

    public static List<File> urlsToFiles(List<String> urls) {
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String path : urls) {
            result.add(JpsPathUtil.urlToFile((String)path));
        }
        return result;
    }

    public static boolean isAndroidProjectWithoutGradleFacet(JpsProject project) {
        return AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(project.getModules());
    }

    public static boolean isAndroidProjectWithoutGradleFacet(ModuleChunk chunk) {
        return AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(chunk.getModules());
    }

    private static boolean isAndroidProjectWithoutGradleFacet(Collection<JpsModule> modules) {
        boolean hasAndroidFacet = false;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension androidFacet = AndroidJpsUtil.getExtension(module);
            if (androidFacet == null) continue;
            hasAndroidFacet = true;
            if (!androidFacet.isGradleProject()) continue;
            return false;
        }
        return hasAndroidFacet;
    }

    public static void collectRTextFilesFromAarDeps(JpsModule module, Collection<Pair<String, String>> result) {
        ArrayList<String> resDirs = new ArrayList<String>();
        AndroidJpsUtil.collectResDirectoriesFromAarDeps(module, resDirs);
        for (String dir : resDirs) {
            File parent = new File(dir).getParentFile();
            File manifestFile = new File(parent, "AndroidManifest.xml");
            File rTxt = new File(parent, "R.txt");
            if (!manifestFile.exists() || !rTxt.exists()) continue;
            try {
                String packageName = AndroidJpsUtil.parsePackageNameFromManifestFile(manifestFile);
                if (packageName == null || packageName.length() <= 0) continue;
                result.add((Pair<String, String>)Pair.create((Object)rTxt.getPath(), (Object)packageName));
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public static void collectResDirectoriesFromAarDeps(JpsModule module, Collection<String> result) {
        Set libs = JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singletonList(module)).runtimeOnly().productionOnly().getLibraries();
        for (JpsLibrary lib : libs) {
            Pair<File, List<File>> pair = AndroidJpsUtil.getResDirAndJarsIfAar(lib);
            File resDir = pair != null ? (File)pair.getFirst() : null;
            if (resDir == null) continue;
            result.add(resDir.getPath());
        }
    }

    public static Pair<File, List<File>> getResDirAndJarsIfAar(JpsLibrary lib) {
        List files = lib.getFiles(JpsOrderRootType.COMPILED);
        if (files.size() == 1) {
            File file = (File)files.get(0);
            if (file.isDirectory() && "res".equals(file.getName())) {
                return Pair.create((Object)file, null);
            }
        } else if (files.size() >= 2) {
            File resDir = null;
            File classesJar = null;
            ArrayList<File> allJars = new ArrayList<File>();
            for (File file : files) {
                if (file.isDirectory()) {
                    if ("res".equals(file.getName())) {
                        resDir = file;
                        continue;
                    }
                    return null;
                }
                if (!file.isFile()) continue;
                if ("classes.jar".equals(file.getName())) {
                    classesJar = file;
                }
                if (FileUtilRt.extensionEquals((String)file.getName(), (String)"jar")) {
                    allJars.add(file);
                    continue;
                }
                return null;
            }
            if (resDir != null && classesJar != null && FileUtil.pathsEqual((String)resDir.getParent(), (String)classesJar.getParent())) {
                return Pair.create((Object)resDir, allJars);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parsePackageNameFromManifestFile(File manifestFile) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(manifestFile));
        try {
            final Ref packageName = new Ref(null);
            FormsParsing.parse((InputStream)inputStream, (IXMLBuilder)new FormsParsing.IXMLBuilderAdapter(){
                boolean processingManifestTagAttrs = false;

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    if (AndroidJpsUtil.MANIFEST_TAG.equals(name)) {
                        this.processingManifestTagAttrs = true;
                    }
                }

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (value != null && "package".equals(key)) {
                        packageName.set((Object)value.trim());
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    6.stop();
                }
            });
            String string = (String)packageName.get();
            return string;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }
}

