/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.android.AndroidAptValidityState;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class AndroidAptStateStorage
extends AbstractStateStorage<String, AndroidAptValidityState> {
    public static final StorageProvider<AndroidAptStateStorage> PROVIDER = new StorageProvider<AndroidAptStateStorage>(){

        public AndroidAptStateStorage createStorage(File targetDataDir) throws IOException {
            return new AndroidAptStateStorage(targetDataDir);
        }
    };
    private static final String RESOURCE_NAMES_STORAGE = "resource_names";

    private AndroidAptStateStorage(File dataStorageRoot) throws IOException {
        super(AndroidJpsUtil.getStorageFile(dataStorageRoot, RESOURCE_NAMES_STORAGE), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new MyDataExternalizer());
    }

    private static class MyDataExternalizer
    implements DataExternalizer<AndroidAptValidityState> {
        private MyDataExternalizer() {
        }

        public void save(DataOutput out, AndroidAptValidityState value) throws IOException {
            value.save(out);
        }

        public AndroidAptValidityState read(DataInput in) throws IOException {
            return new AndroidAptValidityState(in);
        }
    }
}

