/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.samples;

import com.android.tools.idea.npw.NewProjectWizardState;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.gct.idea.samples.SampleImportWizardPath;
import com.google.gct.idea.util.GctBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SampleSetupStep
extends DynamicWizardStepWithHeaderAndDescription {
    private JTextField myProjectNameField;
    private HyperlinkLabel myUrlField;
    private TextFieldWithBrowseButton myProjectLocationField;
    private JPanel myPanel;
    private static final String DEFAULT_SAMPLE_NAME = GctBundle.message("sample.default.name", new Object[0]);

    public SampleSetupStep(Disposable parentDisposable) {
        super(GctBundle.message("sample.setup.title", new Object[0]), GctBundle.message("sample.setup.subtitle", new Object[0]), parentDisposable);
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myPanel);
    }

    public void init() {
        super.init();
        this.myProjectLocationField.addBrowseFolderListener(GctBundle.message("select.project.location", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        String sampleName = SampleSetupStep.getUniqueName(DEFAULT_SAMPLE_NAME);
        this.myState.put(SampleImportWizardPath.SAMPLE_NAME, (Object)sampleName);
        this.myState.put(SampleImportWizardPath.SAMPLE_DIR, (Object)SampleSetupStep.getFileLocation(sampleName).getAbsolutePath());
        this.register(SampleImportWizardPath.SAMPLE_NAME, this.myProjectNameField);
        this.register(SampleImportWizardPath.SAMPLE_DIR, this.myProjectLocationField);
        this.register(SampleImportWizardPath.SAMPLE_URL, (JComponent)this.myUrlField, (ScopedDataBinder.ComponentBinding)new ScopedDataBinder.ComponentBinding<String, HyperlinkLabel>(){

            public void setValue(String newValue, HyperlinkLabel component) {
                component.setHyperlinkTarget(newValue);
                newValue = newValue == null ? "" : newValue;
                component.setHyperlinkText(newValue);
            }
        });
        this.registerValueDeriver(SampleImportWizardPath.SAMPLE_NAME, new SampleNameValueDeriver());
        this.registerValueDeriver(SampleImportWizardPath.SAMPLE_DIR, new SampleDirValueDeriver());
    }

    private static String getUniqueName(String projectName) {
        File file = SampleSetupStep.getFileLocation(projectName);
        String name = projectName;
        int i = 0;
        while (file.exists()) {
            name = projectName + ++i;
            file = SampleSetupStep.getFileLocation(name);
        }
        return name;
    }

    private static File getFileLocation(String projectName) {
        return new File(NewProjectWizardState.getProjectFileDirectory(), projectName.replaceAll("[^a-zA-Z0-9_\\-.]", ""));
    }

    public boolean validate() {
        String applicationName = (String)this.myState.get(SampleImportWizardPath.SAMPLE_NAME);
        if (applicationName == null || applicationName.trim().isEmpty()) {
            this.setErrorHtml(GctBundle.message("application.name.not.set", new Object[0]));
            return false;
        }
        String sampleDir = (String)this.myState.get(SampleImportWizardPath.SAMPLE_DIR);
        WizardUtils.ValidationResult validationResult = WizardUtils.validateLocation((String)sampleDir);
        this.setErrorHtml(validationResult.isOk() ? "" : validationResult.getFormattedMessage());
        return !validationResult.isError();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectNameField;
    }

    public String getStepName() {
        return GctBundle.message("sample.setup.title", new Object[0]);
    }

    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        return DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader((String)GctBundle.message("sample.import.title", new Object[0]));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        HyperlinkLabel hyperlinkLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProjectNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUrlField = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("GitHub URL:");
        jBLabel.setHorizontalAlignment(10);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Project location:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Application name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class SampleDirValueDeriver
    extends ScopedDataBinder.ValueDeriver<String> {
        private SampleDirValueDeriver() {
        }

        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            HashSet filterKeys = new HashSet(1);
            filterKeys.add(SampleImportWizardPath.SAMPLE_NAME);
            return filterKeys;
        }

        public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, String currentValue) {
            String name = (String)state.get(SampleImportWizardPath.SAMPLE_NAME);
            if (name == null) {
                return "";
            }
            return SampleSetupStep.getFileLocation(name).getAbsolutePath();
        }
    }

    private static class SampleNameValueDeriver
    extends ScopedDataBinder.ValueDeriver<String> {
        private SampleNameValueDeriver() {
        }

        public boolean respectUserEdits() {
            return false;
        }

        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            HashSet filterKeys = new HashSet(1);
            filterKeys.add(SampleImportWizardPath.SAMPLE_KEY);
            return filterKeys;
        }

        public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, String currentValue) {
            Sample sample = (Sample)state.get(SampleImportWizardPath.SAMPLE_KEY);
            if (sample == null) {
                return "";
            }
            String sampleName = sample.getTitle();
            return SampleSetupStep.getUniqueName(StringUtil.isEmpty((String)sampleName) ? DEFAULT_SAMPLE_NAME : sampleName);
        }
    }
}

