/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.samples;

import com.appspot.gsamplesindex.samplesindex.SamplesIndex;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.gct.idea.samples.SampleImportWizard;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class SampleImportAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(SampleImportAction.class);

    public void actionPerformed(AnActionEvent e) {
        SamplesIndex.Builder myBuilder = new SamplesIndex.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), null);
        final SamplesIndex samplesService = myBuilder.build();
        final AtomicReference<Object> sampleList = new AtomicReference<Object>(null);
        new Task.Modal(null, GctBundle.message("sample.import.title", new Object[0]), false){

            public void run(ProgressIndicator indicator) {
                indicator.setText(GctBundle.message("sample.index.downloading", new Object[0]));
                try {
                    sampleList.set(samplesService.samples().listSamples().set("technology", (Object)"android").execute());
                }
                catch (IOException ex) {
                    LOG.warn(GctBundle.message("sample.index.download.failed", new Object[0]));
                    sampleList.set(null);
                }
            }
        }.queue();
        if (sampleList.get() == null || ((SampleCollection)sampleList.get()).size() == 0) {
            Messages.showErrorDialog((String)GctBundle.message("sample.index.download.failed", new Object[0]), (String)GctBundle.message("sample.import.error.title", new Object[0]));
            return;
        }
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "sample.importer", "browse", null);
        SampleImportWizard wizard = new SampleImportWizard(null, sampleList.get());
        wizard.show();
    }
}

