/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.wizard;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.run.AppEngineRunConfiguration;
import com.google.gct.idea.appengine.run.AppEngineRunConfigurationType;
import com.google.gct.idea.appengine.wizard.CloudTemplateUtils;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;

public final class CloudModuleUtils {
    public static final String ATTR_MODULE_NAME = "moduleName";
    public static final String ATTR_PACKAGE_NAME = "packageName";
    public static final String ATTR_CLIENT_PACKAGE = "clientPackageName";
    public static final String ATTR_SERVER_MODULE_PATH = "serverModulePath";
    public static final String ATTR_DOC_URL = "docUrl";
    public static final String ATTR_MODULE_TYPE = "moduleType";
    public static final String ATTR_ENDPOINTS_OWNER = "endpointOwnerDomain";
    public static final String ATTR_ENDPOINTS_PACKAGE = "endpointPackagePath";
    private static final String ERROR_MESSAGE_TITLE = "New App Engine Module";
    private static final Logger LOG = Logger.getInstance(CloudModuleUtils.class);

    static void createModule(final Project project, final File templateFile, String moduleName, String packageName, final String clientModuleName) {
        File projectRoot = new File(project.getBasePath());
        File moduleRoot = new File(projectRoot, moduleName);
        FileUtil.createDirectory((File)moduleRoot);
        final HashMap replacementMap = Maps.newHashMap();
        try {
            replacementMap.put("projectOut", moduleRoot.getCanonicalPath());
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Failed to resolve Module output destination : " + e.getMessage()), (String)ERROR_MESSAGE_TITLE);
            LOG.error((Throwable)e);
            return;
        }
        replacementMap.put(ATTR_MODULE_NAME, moduleName);
        replacementMap.put(ATTR_PACKAGE_NAME, packageName);
        if (CloudTemplateUtils.LOCAL_ENDPOINTS_TEMPLATES.contains(templateFile.getName())) {
            CloudModuleUtils.populateEndpointParameters(replacementMap, packageName);
        }
        Template template = Template.createFromPath((File)templateFile);
        final ArrayList allFilesToOpen = Lists.newArrayList();
        RenderingContext context = RenderingContext.Builder.newContext((Template)template, (Project)project).withParams((Map)replacementMap).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).build();
        template.render(context);
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.wizard", templateFile.getName(), null);
        allFilesToOpen.addAll(context.getFilesToOpen());
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                final Module clientModule = Strings.isNullOrEmpty((String)clientModuleName) ? null : ModuleManager.getInstance((Project)project).findModuleByName(clientModuleName);
                final Template clientTemplate = CloudTemplateUtils.getClientModuleTemplate(templateFile.getName());
                CloudModuleUtils.addPropertiesFromClientModule(clientModule, replacementMap);
                DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RenderingContext context;
                        if (clientModule != null && (context = CloudModuleUtils.patchClientModule(clientModule, clientTemplate, replacementMap, project)) != null) {
                            allFilesToOpen.addAll(context.getFilesToOpen());
                        }
                        TemplateUtils.openEditors((Project)project, (Collection)allFilesToOpen, (boolean)true);
                    }
                });
            }
        });
        DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(){

            @Override
            public void run() {
                GradleInvoker.getInstance((Project)project).executeTasks(Collections.singletonList("appengineDownloadSdk"));
            }
        });
    }

    private static void addPropertiesFromClientModule(Module clientModule, Map<String, Object> replacementMap) {
        AndroidFacet facet;
        replacementMap.put("debugKeystoreSha1", "");
        replacementMap.put(ATTR_CLIENT_PACKAGE, "");
        if (clientModule != null && (facet = AndroidFacet.getInstance((Module)clientModule)) != null) {
            try {
                replacementMap.put("debugKeystoreSha1", KeystoreUtils.sha1((File)KeystoreUtils.getDebugKeystore((AndroidFacet)facet)));
            }
            catch (Exception e) {
                LOG.info("Failed to calculate SHA-1 of debug keystore", (Throwable)e);
            }
            Manifest manifest = facet.getManifest();
            if (manifest != null) {
                replacementMap.put(ATTR_CLIENT_PACKAGE, manifest.getPackage().getValue());
            }
        }
    }

    private static RenderingContext patchClientModule(Module clientModule, Template clientTemplate, Map<String, Object> replacementMap, Project project) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)clientModule);
        VirtualFile targetFolder = CloudModuleUtils.findTargetContentRoot(clientModule);
        if (targetFolder == null || facet == null) {
            return null;
        }
        String backendModulePath = (String)replacementMap.get("projectOut");
        replacementMap.put(ATTR_SERVER_MODULE_PATH, FileUtil.getRelativePath((String)targetFolder.getPath(), (String)backendModulePath, (char)'/'));
        replacementMap.put("projectOut", targetFolder.getPath());
        List sourceProviders = IdeaSourceProvider.getSourceProvidersForFile((AndroidFacet)facet, (VirtualFile)targetFolder, (SourceProvider)facet.getMainSourceProvider());
        replacementMap.put("manifestDir", ((SourceProvider)sourceProviders.get(0)).getManifestFile().getParentFile().getPath());
        File clientContentRoot = new File(targetFolder.getPath());
        RenderingContext context = RenderingContext.Builder.newContext((Template)clientTemplate, (Project)project).withParams(replacementMap).withOutputRoot(clientContentRoot).withModuleRoot(clientContentRoot).build();
        clientTemplate.render(context);
        return context;
    }

    private static VirtualFile findTargetContentRoot(Module clientModule) {
        VirtualFile[] contentRoots;
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)clientModule).getContentRoots()) {
            if (contentRoot.findChild("build.gradle") == null) continue;
            return contentRoot;
        }
        return contentRoots.length > 0 ? contentRoots[0] : null;
    }

    private static void createRunConfiguration(Project project, Module module) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName(), AppEngineRunConfigurationType.getInstance().getFactory());
        settings.setSingleton(true);
        AppEngineRunConfiguration configuration = (AppEngineRunConfiguration)settings.getConfiguration();
        configuration.setModule(module);
        configuration.setSyncWithGradle(Boolean.valueOf(true));
        runManager.addConfiguration(settings, false);
    }

    @VisibleForTesting
    static void populateEndpointParameters(Map<String, Object> replacementMap, String rootPackage) {
        replacementMap.put(ATTR_ENDPOINTS_OWNER, StringUtil.join((String[])((String[])ArrayUtil.reverseArray((Object[])rootPackage.split("\\."))), (String)"."));
        replacementMap.put(ATTR_ENDPOINTS_PACKAGE, "");
    }

    private CloudModuleUtils() {
    }
}

