/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MavenServerUtil {
    private static final Properties mySystemPropertiesCache;

    public static Properties collectSystemProperties() {
        return mySystemPropertiesCache;
    }

    public static File findMavenBasedir(File workingDir) {
        File baseDir = workingDir;
        File dir = workingDir;
        while ((dir = dir.getParentFile()) != null) {
            if (dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return ".mvn".equals(name);
                }
            }).length <= 0) continue;
            baseDir = dir;
            break;
        }
        try {
            return baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            return baseDir.getAbsoluteFile();
        }
    }

    private static boolean isMagicalProperty(String key) {
        return key.startsWith("=");
    }

    static {
        Properties res = new Properties();
        res.putAll((Map<?, ?>)System.getProperties());
        Iterator<Object> itr = res.keySet().iterator();
        while (itr.hasNext()) {
            String propertyName = itr.next().toString();
            if (!propertyName.startsWith("idea.")) continue;
            itr.remove();
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (MavenServerUtil.isMagicalProperty(key)) continue;
            if (SystemInfo.isWindows) {
                key = key.toUpperCase();
            }
            res.setProperty("env." + key, entry.getValue());
        }
        mySystemPropertiesCache = res;
    }
}

