/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MathDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("FloatMath", "Using `FloatMath` instead of `Math`", "In older versions of Android, using `android.util.FloatMath` was recommended for performance reasons when operating on floats. However, on modern hardware doubles are just as fast as float (though they take more memory), and in recent versions of Android, `FloatMath` is actually slower than using `java.lang.Math` due to the way the JIT optimizes `java.lang.Math`. Therefore, you should use `Math` instead of `FloatMath` if you are only targeting Froyo and above.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(MathDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableCallNames() {
        return Arrays.asList("sin", "cos", "ceil", "sqrt", "floor");
    }

    @Override
    public void checkCall(ClassContext context, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        String owner = call.owner;
        if (owner.equals("android/util/FloatMath") && context.getProject().getMinSdk() >= 8) {
            String message = String.format("Use `java.lang.Math#%1$s` instead of `android.util.FloatMath#%1$s()` since it is faster as of API 8", call.name);
            context.report(ISSUE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), message);
        }
    }
}

