/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.resources.ResourceType;
import com.intellij.util.containers.Stack;
import java.io.Reader;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.ResourceEntry;

public abstract class ValueResourcesFileParser
implements IXMLBuilder {
    private boolean mySeenResources = false;
    private String myLastTypeAttr = null;
    private String myLastNameAttr = null;
    private final Stack<String> myContextNames = new Stack();

    public void startBuilding(String systemID, int lineNr) throws Exception {
    }

    public void newProcessingInstruction(String target, Reader reader) throws Exception {
    }

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        if (!this.mySeenResources) {
            if ("resources".equals(name)) {
                this.mySeenResources = true;
            } else {
                this.stop();
            }
        }
        this.myLastNameAttr = null;
        this.myLastTypeAttr = null;
    }

    protected abstract void stop();

    protected abstract void process(ResourceEntry var1);

    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        if ("name".equals(key)) {
            this.myLastNameAttr = value;
        } else if ("type".equals(key)) {
            this.myLastTypeAttr = value;
        }
    }

    public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
        if (this.myLastNameAttr != null && name != null) {
            ResourceType resType;
            String resTypeStr = "item".equals(name) ? this.myLastTypeAttr : AndroidCommonUtils.getResourceTypeByTagName(name);
            ResourceType resourceType = resType = resTypeStr != null ? ResourceType.getEnum((String)resTypeStr) : null;
            if (resType != null) {
                if (resType == ResourceType.ATTR) {
                    String contextName = (String)this.myContextNames.peek();
                    this.process(new ResourceEntry(resTypeStr, this.myLastNameAttr, contextName));
                } else {
                    this.process(new ResourceEntry(resTypeStr, this.myLastNameAttr, ""));
                }
            }
        }
        this.myContextNames.push((Object)(this.myLastNameAttr != null ? this.myLastNameAttr : ""));
    }

    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        this.myContextNames.pop();
    }

    public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
    }

    public Object getResult() throws Exception {
        return null;
    }
}

