/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.utils.ILogger;
import com.intellij.openapi.diagnostic.Logger;

public class MessageBuildingSdkLog
implements ILogger {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.MessageBuildingSdkLog");
    private final StringBuilder builder = new StringBuilder();

    public void warning(String warningFormat, Object ... args) {
        LOG.info(String.format(warningFormat, args));
    }

    public void info(String msgFormat, Object ... args) {
        LOG.debug(String.format(msgFormat, args));
    }

    public void verbose(String msgFormat, Object ... args) {
    }

    public void error(Throwable t, String errorFormat, Object ... args) {
        String message;
        if (t != null) {
            message = t.getMessage();
            if (message != null) {
                this.builder.append(message).append('\n');
            }
            LOG.info(t);
        }
        if (errorFormat != null) {
            message = String.format(errorFormat, args);
            LOG.info(message);
            this.builder.append(message).append('\n');
        }
    }

    public String getErrorMessage() {
        if (this.builder.length() > 0) {
            this.builder.delete(this.builder.length() - 1, this.builder.length());
        }
        return this.builder.toString();
    }
}

