/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.jarutils.DebugKeyProvider;
import com.android.jarutils.JavaResourceFilter;
import com.android.jarutils.SignedJarBuilder;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.AndroidNativeLibData;

public class AndroidApkBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidApkBuilder");
    private static final String UNALIGNED_SUFFIX = ".unaligned";
    private static final String EXT_NATIVE_LIB = "so";

    private AndroidApkBuilder() {
    }

    private static Map<AndroidCompilerMessageKind, List<String>> filterUsingKeystoreMessages(Map<AndroidCompilerMessageKind, List<String>> messages) {
        List<String> infoMessages = messages.get((Object)AndroidCompilerMessageKind.INFORMATION);
        if (infoMessages == null) {
            infoMessages = new ArrayList<String>();
            messages.put(AndroidCompilerMessageKind.INFORMATION, infoMessages);
        }
        List<String> errors = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        Iterator<String> iterator = errors.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.startsWith("Using keystore:")) continue;
            infoMessages.add(s);
            iterator.remove();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectDuplicateEntries(String rootFile, Set<String> entries, Set<String> result) throws IOException {
        JavaResourceFilter javaResourceFilter = new JavaResourceFilter();
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            fis = new FileInputStream(rootFile);
            zis = new ZipInputStream(fis);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (javaResourceFilter.checkEntry(name) && !entries.add(name)) {
                    result.add(name);
                }
                zis.closeEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Map<AndroidCompilerMessageKind, List<String>> execute(String resPackagePath, String dexPath, String[] resourceRoots, String[] externalJars, String[] nativeLibsFolders, Collection<AndroidNativeLibData> additionalNativeLibs, String finalApk, boolean unsigned, String sdkPath, IAndroidTarget target, String customKeystorePath, Condition<File> resourceFilter) throws IOException {
        block12: {
            block10: {
                block11: {
                    block8: {
                        block9: {
                            testingManager = AndroidBuildTestingManager.getTestingManager();
                            if (testingManager != null) {
                                testingManager.getCommandExecutor().log(StringUtil.join((String[])new String[]{"apk_builder", resPackagePath, dexPath, AndroidBuildTestingManager.arrayToString(resourceRoots), AndroidBuildTestingManager.arrayToString(externalJars), AndroidBuildTestingManager.arrayToString(nativeLibsFolders), additionalNativeLibs.toString(), finalApk, Boolean.toString(unsigned), sdkPath, customKeystorePath}, (String)"\n"));
                            }
                            map = new HashMap();
                            map.put(AndroidCompilerMessageKind.ERROR, new ArrayList<E>());
                            map.put(AndroidCompilerMessageKind.WARNING, new ArrayList<E>());
                            outputDir = new File(finalApk).getParentFile();
                            if (!outputDir.exists() && !outputDir.mkdirs()) {
                                ((List)map.get((Object)AndroidCompilerMessageKind.ERROR)).add("Cannot create directory " + outputDir.getPath());
                                return map;
                            }
                            additionalLibsDir = null;
                            try {
                                if (additionalNativeLibs.size() <= 0) ** GOTO lbl33
                                additionalLibsDir = FileUtil.createTempDirectory((String)"android_additional_libs", (String)"tmp");
                                if (AndroidApkBuilder.copyNativeLibs(additionalNativeLibs, additionalLibsDir, (Map<AndroidCompilerMessageKind, List<String>>)map)) break block8;
                                var16_16 = map;
                                if (additionalLibsDir == null) break block9;
                            }
                            catch (Throwable var21_23) {
                                if (additionalLibsDir != null) {
                                    FileUtil.delete(additionalLibsDir);
                                }
                                throw var21_23;
                            }
                            FileUtil.delete((File)additionalLibsDir);
                        }
                        return var16_16;
                    }
                    nativeLibsFolders = (String[])ArrayUtil.append((Object[])nativeLibsFolders, (Object)additionalLibsDir.getPath());
lbl33:
                    // 2 sources

                    if (!unsigned) break block10;
                    var16_17 = AndroidApkBuilder.filterUsingKeystoreMessages(AndroidApkBuilder.finalPackage(dexPath, resourceRoots, externalJars, nativeLibsFolders, finalApk, resPackagePath, customKeystorePath, false, resourceFilter));
                    if (additionalLibsDir == null) break block11;
                    FileUtil.delete((File)additionalLibsDir);
                }
                return var16_17;
            }
            zipAlignPath = AndroidCommonUtils.getZipAlign(sdkPath, target);
            withAlignment = new File(zipAlignPath).exists();
            unalignedApk = AndroidCommonUtils.addSuffixToFileName(finalApk, ".unaligned");
            map2 = AndroidApkBuilder.filterUsingKeystoreMessages(AndroidApkBuilder.finalPackage(dexPath, resourceRoots, externalJars, nativeLibsFolders, withAlignment != false ? unalignedApk : finalApk, resPackagePath, customKeystorePath, true, resourceFilter));
            map.putAll(map2);
            if (withAlignment && ((List)map.get((Object)AndroidCompilerMessageKind.ERROR)).size() == 0) {
                map2 = AndroidExecutionUtil.doExecute(new String[]{zipAlignPath, "-f", "4", unalignedApk, finalApk});
                map.putAll(map2);
            }
            var20_22 = map;
            if (additionalLibsDir == null) break block12;
            FileUtil.delete((File)additionalLibsDir);
        }
        return var20_22;
    }

    private static boolean copyNativeLibs(Collection<AndroidNativeLibData> libs, File targetDir, Map<AndroidCompilerMessageKind, List<String>> map) throws IOException {
        for (AndroidNativeLibData lib : libs) {
            String path = lib.getPath();
            File srcFile = new File(path);
            if (!srcFile.exists()) {
                map.get((Object)AndroidCompilerMessageKind.WARNING).add("File not found: " + FileUtil.toSystemDependentName((String)path) + ". The native library won't be placed into APK");
                continue;
            }
            File dstDir = new File(targetDir, lib.getArchitecture());
            File dstFile = new File(dstDir, lib.getTargetFileName());
            if (dstFile.exists()) {
                map.get((Object)AndroidCompilerMessageKind.WARNING).add("Duplicate native library " + dstFile.getName() + "; " + dstFile.getPath() + " already exists");
                continue;
            }
            if (!dstDir.exists() && !dstDir.mkdirs()) {
                map.get((Object)AndroidCompilerMessageKind.ERROR).add("Cannot create directory: " + FileUtil.toSystemDependentName((String)dstDir.getPath()));
                continue;
            }
            FileUtil.copy((File)srcFile, (File)dstFile);
        }
        return map.get((Object)AndroidCompilerMessageKind.ERROR).size() == 0;
    }

    /*
     * Exception decompiling
     */
    private static Map<AndroidCompilerMessageKind, List<String>> finalPackage(String dexPath, String[] javaResourceRoots, String[] externalJars, String[] nativeLibsFolders, String outputApk, String apkPath, String customKeystorePath, boolean signed, Condition<File> resourceFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 117[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DebugKeyProvider createDebugKeyProvider(final Map<AndroidCompilerMessageKind, List<String>> result, String path) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, DebugKeyProvider.KeytoolException, AndroidLocation.AndroidLocationException {
        return new DebugKeyProvider(path, null, new DebugKeyProvider.IKeyGenOutput(){

            public void err(String message) {
                ((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).add("Error during key creation: " + message);
            }

            public void out(String message) {
                ((List)result.get((Object)AndroidCompilerMessageKind.INFORMATION)).add("Info message during key creation: " + message);
            }
        });
    }

    private static void writeNativeLibraries(SignedJarBuilder builder, File nativeLibsFolder, File child, boolean debugBuild, Set<String> added) throws IOException {
        ArrayList<File> list = new ArrayList<File>();
        AndroidApkBuilder.collectNativeLibraries(child, list, debugBuild);
        for (File file : list) {
            String relativePath = FileUtil.getRelativePath((File)nativeLibsFolder, (File)file);
            String path = FileUtil.toSystemIndependentName((String)("lib" + File.separator + relativePath));
            if (added.add(path)) {
                builder.writeFile(file, path);
                LOG.info("Native lib file added to APK: " + file.getPath());
                continue;
            }
            LOG.info("Duplicate in APK: native lib file " + file.getPath() + " won't be added.");
        }
    }

    private static Map<AndroidCompilerMessageKind, List<String>> addExceptionMessage(Exception e, Map<AndroidCompilerMessageKind, List<String>> result) {
        LOG.info((Throwable)e);
        String simpleExceptionName = e.getClass().getCanonicalName();
        result.get((Object)AndroidCompilerMessageKind.ERROR).add(simpleExceptionName + ": " + e.getMessage());
        return result;
    }

    public static void collectNativeLibraries(File file, List<File> result, boolean debugBuild) {
        File[] children;
        if (!file.isDirectory()) {
            if (FileUtilRt.extensionEquals((String)file.getName(), (String)EXT_NATIVE_LIB) || debugBuild && !FileUtilRt.extensionEquals((String)file.getName(), (String)"jar")) {
                result.add(file);
            }
        } else if (JavaResourceFilter.checkFolderForPackaging((String)file.getName()) && (children = file.listFiles()) != null) {
            for (File child : children) {
                AndroidApkBuilder.collectNativeLibraries(child, result, debugBuild);
            }
        }
    }

    public static void collectStandardJavaResources(File folder, Collection<File> result, Condition<File> filter) {
        File[] children = folder.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!child.exists()) continue;
                if (child.isDirectory()) {
                    if (!JavaResourceFilter.checkFolderForPackaging((String)child.getName()) || !filter.value((Object)child)) continue;
                    AndroidApkBuilder.collectStandardJavaResources(child, result, filter);
                    continue;
                }
                if (!AndroidApkBuilder.checkFileForPackaging(child) || !filter.value((Object)child)) continue;
                result.add(child);
            }
        }
    }

    private static void writeStandardJavaResources(Collection<File> resources, File sourceRoot, SignedJarBuilder jarBuilder, Set<String> added) throws IOException {
        for (File child : resources) {
            String relativePath = FileUtil.getRelativePath((File)sourceRoot, (File)child);
            if (relativePath == null || added.contains(relativePath)) continue;
            jarBuilder.writeFile(child, FileUtil.toSystemIndependentName((String)relativePath));
            added.add(relativePath);
        }
    }

    public static boolean checkFileForPackaging(File file) {
        String fileName = FileUtil.getNameWithoutExtension((File)file);
        if (fileName.length() > 0) {
            String extension = FileUtilRt.getExtension((String)file.getName());
            if ("apk".equals(extension)) {
                return false;
            }
            return JavaResourceFilter.checkFileForPackaging((String)fileName, (String)extension);
        }
        return false;
    }

    private static class MyResourceFilter
    extends JavaResourceFilter {
        private final Set<String> myExcludedEntries;

        public MyResourceFilter(Set<String> excludedEntries) {
            this.myExcludedEntries = excludedEntries;
        }

        public boolean checkEntry(String name) {
            if (this.myExcludedEntries.contains(name)) {
                return false;
            }
            return super.checkEntry(name);
        }
    }
}

