/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DataBindingOutputParser
implements PatternAwareOutputParser {
    public static final String ERROR_LOG_PREFIX = "****/ data binding error ****";
    public static final String ERROR_LOG_SUFFIX = "****\\ data binding error ****";
    public static final String MSG_KEY = "msg:";
    public static final String LOCATION_KEY = "loc:";
    public static final String FILE_KEY = "file:";

    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        int errorStart = line.indexOf(ERROR_LOG_PREFIX);
        if (errorStart >= 0) {
            logger.verbose("found data binding error start", new Object[0]);
            int errorEnd = line.indexOf(ERROR_LOG_SUFFIX, errorStart + ERROR_LOG_PREFIX.length());
            if (errorEnd >= 0) {
                logger.verbose("found data binding error end", new Object[0]);
                return DataBindingOutputParser.parseErrorIn(line.substring(errorStart + ERROR_LOG_PREFIX.length(), errorEnd), messages);
            }
        }
        return false;
    }

    private static boolean parseErrorIn(String output, List<Message> messages) {
        String message;
        String file = "";
        ArrayList<Location> locations = new ArrayList<Location>();
        int msgStart = output.indexOf(MSG_KEY);
        if (msgStart < 0) {
            message = output;
        } else {
            int fileStart = output.indexOf(FILE_KEY, msgStart + MSG_KEY.length());
            if (fileStart < 0) {
                message = output;
            } else {
                message = output.substring(msgStart + MSG_KEY.length(), fileStart);
                int locStart = output.indexOf(LOCATION_KEY, fileStart + FILE_KEY.length());
                if (locStart < 0) {
                    file = output.substring(fileStart + FILE_KEY.length()).trim();
                } else {
                    file = output.substring(fileStart + FILE_KEY.length(), locStart).trim();
                    int nextLoc = 0;
                    while (nextLoc >= 0) {
                        nextLoc = output.indexOf(LOCATION_KEY, locStart + LOCATION_KEY.length());
                        Location loc = nextLoc < 0 ? Location.fromUserReadableString(output.substring(locStart + LOCATION_KEY.length())) : Location.fromUserReadableString(output.substring(locStart + LOCATION_KEY.length(), nextLoc));
                        if (loc.isValid()) {
                            locations.add(loc);
                        }
                        locStart = nextLoc;
                    }
                }
            }
        }
        if (StringUtil.isEmpty((String)file)) {
            return false;
        }
        ArrayList<SourceFilePosition> sourceFilePositions = new ArrayList<SourceFilePosition>();
        File sourceFile = new File(file);
        if (locations.size() == 0) {
            messages.add(new Message(Message.Kind.ERROR, message, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
        } else {
            for (Location location : locations) {
                sourceFilePositions.add(new SourceFilePosition(sourceFile, new SourcePosition(location.startLine, location.startOffset, 0, location.endLine, location.endOffset, 0)));
            }
            SourceFilePosition first = (SourceFilePosition)sourceFilePositions.get(0);
            if (locations.size() == 1) {
                messages.add(new Message(Message.Kind.ERROR, message, first, new SourceFilePosition[0]));
            } else {
                SourceFilePosition[] rest = new SourceFilePosition[sourceFilePositions.size() - 1];
                for (int i = 1; i < sourceFilePositions.size(); ++i) {
                    rest[i - 1] = (SourceFilePosition)sourceFilePositions.get(i);
                }
                messages.add(new Message(Message.Kind.ERROR, message, first, rest));
            }
        }
        return true;
    }

    private static class Location {
        public static final int NaN = -1;
        public int startLine;
        public int startOffset;
        public int endLine;
        public int endOffset;
        public Location parentLocation;

        public Location() {
            this.endLine = -1;
            this.startLine = -1;
            this.endOffset = -1;
            this.startOffset = -1;
        }

        public Location(Location other) {
            this.startOffset = other.startOffset;
            this.endOffset = other.endOffset;
            this.startLine = other.startLine;
            this.endLine = other.endLine;
        }

        public Location(int startLine, int startOffset, int endLine, int endOffset) {
            this.startOffset = startOffset;
            this.startLine = startLine;
            this.endLine = endLine;
            this.endOffset = endOffset;
        }

        public String toString() {
            return "Location{startLine=" + this.startLine + ", startOffset=" + this.startOffset + ", endLine=" + this.endLine + ", endOffset=" + this.endOffset + ", parentLocation=" + this.parentLocation + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.endLine != location.endLine) {
                return false;
            }
            if (this.endOffset != location.endOffset) {
                return false;
            }
            if (this.startLine != location.startLine) {
                return false;
            }
            if (this.startOffset != location.startOffset) {
                return false;
            }
            return !(this.parentLocation != null ? !this.parentLocation.equals(location.parentLocation) : location.parentLocation != null);
        }

        public int hashCode() {
            int result = this.startLine;
            result = 31 * result + this.startOffset;
            result = 31 * result + this.endLine;
            result = 31 * result + this.endOffset;
            return result;
        }

        public boolean isValid() {
            return this.startLine != -1 && this.endLine != -1 && this.startOffset != -1 && this.endOffset != -1;
        }

        public boolean contains(Location other) {
            if (this.startLine > other.startLine) {
                return false;
            }
            if (this.startLine == other.startLine && this.startOffset > other.startOffset) {
                return false;
            }
            if (this.endLine < other.endLine) {
                return false;
            }
            return this.endLine != other.endLine || this.endOffset >= other.endOffset;
        }

        private Location getValidParentAbsoluteLocation() {
            if (this.parentLocation == null) {
                return null;
            }
            if (this.parentLocation.isValid()) {
                return this.parentLocation.toAbsoluteLocation();
            }
            return this.parentLocation.getValidParentAbsoluteLocation();
        }

        public Location toAbsoluteLocation() {
            boolean sameLine;
            Location absoluteParent = this.getValidParentAbsoluteLocation();
            if (absoluteParent == null) {
                return this;
            }
            Location copy = new Location(this);
            boolean bl = sameLine = copy.startLine == copy.endLine;
            if (copy.startLine == 0) {
                copy.startOffset += absoluteParent.startOffset;
            }
            if (sameLine) {
                copy.endOffset += absoluteParent.startOffset;
            }
            copy.startLine += absoluteParent.startLine;
            copy.endLine += absoluteParent.startLine;
            return copy;
        }

        public static Location fromUserReadableString(String str) {
            int glue = str.indexOf(45);
            if (glue == -1) {
                return new Location();
            }
            String start = str.substring(0, glue);
            String end = str.substring(glue + 1);
            int[] point = new int[]{-1, -1};
            Location location = new Location();
            Location.parsePoint(start, point);
            location.startLine = point[0];
            location.startOffset = point[1];
            point[1] = -1;
            point[0] = -1;
            Location.parsePoint(end, point);
            location.endLine = point[0];
            location.endOffset = point[1];
            return location;
        }

        private static boolean parsePoint(String content, int[] into) {
            int index = content.indexOf(58);
            if (index == -1) {
                return false;
            }
            into[0] = Integer.parseInt(content.substring(0, index).trim());
            into[1] = Integer.parseInt(content.substring(index + 1).trim());
            return true;
        }
    }
}

