/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CoverageSuiteChooserDialog
extends DialogWrapper {
    private static final String LOCAL = "Local";
    private final Project myProject;
    private final CheckboxTree mySuitesTree;
    private final CoverageDataManager myCoverageManager;
    private static final Logger LOG = Logger.getInstance((String)("#" + CoverageSuiteChooserDialog.class.getName()));
    private final CheckedTreeNode myRootNode;
    private CoverageEngine myEngine;

    public CoverageSuiteChooserDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance(project);
        this.myRootNode = new CheckedTreeNode((Object)"");
        this.initTree();
        this.mySuitesTree = new CheckboxTree(new SuitesRenderer(), this.myRootNode){

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, (Convertor)new Convertor<TreePath, String>(){

                    public String convert(TreePath path) {
                        DefaultMutableTreeNode component = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object userObject = component.getUserObject();
                        if (userObject instanceof CoverageSuite) {
                            return ((CoverageSuite)userObject).getPresentableName();
                        }
                        return userObject.toString();
                    }
                });
            }
        };
        this.mySuitesTree.getEmptyText().appendText("No coverage suites configured.");
        this.mySuitesTree.setRootVisible(false);
        this.mySuitesTree.setShowsRootHandles(false);
        TreeUtil.installActions((JTree)this.mySuitesTree);
        TreeUtil.expandAll((JTree)this.mySuitesTree);
        TreeUtil.selectFirstNode((JTree)this.mySuitesTree);
        this.mySuitesTree.setMinimumSize(new Dimension(25, -1));
        this.setOKButtonText("Show selected");
        this.init();
        this.setTitle("Choose Coverage Suite to Display");
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.mySuitesTree);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySuitesTree;
    }

    protected JComponent createNorthPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddExternalSuiteAction());
        group.add((AnAction)new DeleteSuiteAction());
        group.add((AnAction)new SwitchEngineAction());
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
    }

    protected void doOKAction() {
        List<CoverageSuite> suites = this.collectSelectedSuites();
        this.myCoverageManager.chooseSuitesBundle(suites.isEmpty() ? null : new CoverageSuitesBundle(suites.toArray(new CoverageSuite[suites.size()])));
        super.doOKAction();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), new NoCoverageAction(), this.getCancelAction()};
    }

    private Set<CoverageEngine> collectEngines() {
        HashSet<CoverageEngine> engines = new HashSet<CoverageEngine>();
        for (CoverageSuite suite : this.myCoverageManager.getSuites()) {
            engines.add(suite.getCoverageEngine());
        }
        return engines;
    }

    private static String getCoverageRunnerTitle(CoverageRunner coverageRunner) {
        return coverageRunner.getPresentableName() + " Coverage";
    }

    private static CoverageRunner getCoverageRunner(VirtualFile file) {
        for (CoverageRunner runner : (CoverageRunner[])Extensions.getExtensions(CoverageRunner.EP_NAME)) {
            if (!Comparing.strEqual((String)file.getExtension(), (String)runner.getDataFileExtension())) continue;
            return runner;
        }
        return null;
    }

    private List<CoverageSuite> collectSelectedSuites() {
        final ArrayList<CoverageSuite> suites = new ArrayList<CoverageSuite>();
        TreeUtil.traverse((TreeNode)this.myRootNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object treeNode) {
                Object userObject;
                if (treeNode instanceof CheckedTreeNode && ((CheckedTreeNode)treeNode).isChecked() && (userObject = ((CheckedTreeNode)treeNode).getUserObject()) instanceof CoverageSuite) {
                    suites.add((CoverageSuite)userObject);
                }
                return true;
            }
        });
        return suites;
    }

    private void initTree() {
        this.myRootNode.removeAllChildren();
        HashMap grouped = new HashMap();
        CoverageSuiteChooserDialog.groupSuites((HashMap<CoverageRunner, Map<String, List<CoverageSuite>>>)grouped, this.myCoverageManager.getSuites(), this.myEngine);
        CoverageSuitesBundle currentSuite = this.myCoverageManager.getCurrentSuitesBundle();
        ArrayList runners = new ArrayList(grouped.keySet());
        Collections.sort(runners, new Comparator<CoverageRunner>(){

            @Override
            public int compare(CoverageRunner o1, CoverageRunner o2) {
                return o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
            }
        });
        for (CoverageRunner runner : runners) {
            DefaultMutableTreeNode runnerNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.getCoverageRunnerTitle(runner));
            Map providers = (Map)grouped.get((Object)runner);
            DefaultMutableTreeNode remoteNode = new DefaultMutableTreeNode("Remote");
            if (providers.size() == 1) {
                String providersKey = (String)providers.keySet().iterator().next();
                DefaultMutableTreeNode suitesNode = runnerNode;
                if (!Comparing.strEqual((String)providersKey, (String)DefaultCoverageFileProvider.class.getName())) {
                    suitesNode = remoteNode;
                    runnerNode.add(remoteNode);
                }
                List suites = (List)providers.get(providersKey);
                Collections.sort(suites, new Comparator<CoverageSuite>(){

                    @Override
                    public int compare(CoverageSuite o1, CoverageSuite o2) {
                        return o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
                    }
                });
                for (CoverageSuite suite : suites) {
                    CheckedTreeNode treeNode = new CheckedTreeNode((Object)suite);
                    treeNode.setChecked((currentSuite != null && currentSuite.contains(suite) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                    suitesNode.add((MutableTreeNode)treeNode);
                }
            } else {
                DefaultMutableTreeNode localNode = new DefaultMutableTreeNode(LOCAL);
                runnerNode.add(localNode);
                runnerNode.add(remoteNode);
                for (String aClass : providers.keySet()) {
                    DefaultMutableTreeNode node = Comparing.strEqual((String)aClass, (String)DefaultCoverageFileProvider.class.getName()) ? localNode : remoteNode;
                    for (CoverageSuite suite : (List)providers.get(aClass)) {
                        CheckedTreeNode treeNode = new CheckedTreeNode((Object)suite);
                        treeNode.setChecked((currentSuite != null && currentSuite.contains(suite) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                        node.add((MutableTreeNode)treeNode);
                    }
                }
            }
            this.myRootNode.add((MutableTreeNode)runnerNode);
        }
    }

    private static void groupSuites(HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> grouped, CoverageSuite[] suites, CoverageEngine engine) {
        for (CoverageSuite suite : suites) {
            String sourceProvider;
            ArrayList<CoverageSuite> list;
            CoverageFileProvider provider;
            if (engine != null && suite.getCoverageEngine() != engine || (provider = suite.getCoverageDataFileProvider()) instanceof DefaultCoverageFileProvider && Comparing.strEqual((String)((DefaultCoverageFileProvider)provider).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName()) && !provider.ensureFileExists()) continue;
            CoverageRunner runner = suite.getRunner();
            Map byProviders = (Map)grouped.get((Object)runner);
            if (byProviders == null) {
                byProviders = new HashMap();
                grouped.put((Object)runner, (Object)byProviders);
            }
            if ((list = (ArrayList<CoverageSuite>)byProviders.get(sourceProvider = provider instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)provider).getSourceProvider() : provider.getClass().getName())) == null) {
                list = new ArrayList<CoverageSuite>();
                byProviders.put(sourceProvider, list);
            }
            list.add(suite);
        }
    }

    private void updateTree() {
        ((DefaultTreeModel)this.mySuitesTree.getModel()).reload();
        TreeUtil.expandAll((JTree)this.mySuitesTree);
    }

    private class SwitchEngineAction
    extends ComboBoxAction {
        private SwitchEngineAction() {
        }

        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup engChooser = new DefaultActionGroup();
            for (final CoverageEngine engine : CoverageSuiteChooserDialog.this.collectEngines()) {
                engChooser.add(new AnAction(engine.getPresentableText()){

                    public void actionPerformed(AnActionEvent e) {
                        CoverageSuiteChooserDialog.this.myEngine = engine;
                        CoverageSuiteChooserDialog.this.initTree();
                        CoverageSuiteChooserDialog.this.updateTree();
                    }
                });
            }
            return engChooser;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(CoverageSuiteChooserDialog.this.collectEngines().size() > 1);
        }
    }

    private class DeleteSuiteAction
    extends AnAction {
        public DeleteSuiteAction() {
            super("Delete", "Delete", PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)CoverageSuiteChooserDialog.this.mySuitesTree);
        }

        public void actionPerformed(AnActionEvent e) {
            CheckedTreeNode[] selectedNodes;
            for (CheckedTreeNode selectedNode : selectedNodes = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null)) {
                CoverageSuite selectedSuite;
                Object userObject = selectedNode.getUserObject();
                if (!(userObject instanceof CoverageSuite) || !((selectedSuite = (CoverageSuite)userObject).getCoverageDataFileProvider() instanceof DefaultCoverageFileProvider) || !Comparing.strEqual((String)((DefaultCoverageFileProvider)selectedSuite.getCoverageDataFileProvider()).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName())) continue;
                CoverageSuiteChooserDialog.this.myCoverageManager.removeCoverageSuite(selectedSuite);
                TreeUtil.removeLastPathComponent((JTree)CoverageSuiteChooserDialog.this.mySuitesTree, (TreePath)new TreePath(selectedNode.getPath()));
            }
        }

        public void update(AnActionEvent e) {
            CheckedTreeNode[] selectedSuites = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            for (CheckedTreeNode node : selectedSuites) {
                CoverageSuite selectedSuite;
                Object userObject = node.getUserObject();
                if (!(userObject instanceof CoverageSuite) || !((selectedSuite = (CoverageSuite)userObject).getCoverageDataFileProvider() instanceof DefaultCoverageFileProvider) || !Comparing.strEqual((String)((DefaultCoverageFileProvider)selectedSuite.getCoverageDataFileProvider()).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName())) continue;
                presentation.setEnabled(true);
            }
        }
    }

    private class AddExternalSuiteAction
    extends AnAction {
        public AddExternalSuiteAction() {
            super("Add", "Add", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)CoverageSuiteChooserDialog.this.mySuitesTree);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileSelectable(VirtualFile file) {
                    return CoverageSuiteChooserDialog.getCoverageRunner(file) != null;
                }
            }, (Project)CoverageSuiteChooserDialog.this.myProject, null);
            if (file != null) {
                TreeNode childNode;
                CoverageRunner coverageRunner = CoverageSuiteChooserDialog.getCoverageRunner(file);
                LOG.assertTrue(coverageRunner != null);
                CoverageSuite coverageSuite = CoverageSuiteChooserDialog.this.myCoverageManager.addExternalCoverageSuite(file.getName(), file.getTimeStamp(), coverageRunner, new DefaultCoverageFileProvider(file.getPath()));
                String coverageRunnerTitle = CoverageSuiteChooserDialog.getCoverageRunnerTitle(coverageRunner);
                DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)CoverageSuiteChooserDialog.this.myRootNode, (Object)coverageRunnerTitle);
                if (node == null) {
                    node = new DefaultMutableTreeNode(coverageRunnerTitle);
                    CoverageSuiteChooserDialog.this.myRootNode.add((MutableTreeNode)node);
                }
                if (node.getChildCount() > 0 && !((childNode = node.getChildAt(0)) instanceof CheckedTreeNode)) {
                    if (CoverageSuiteChooserDialog.LOCAL.equals(((DefaultMutableTreeNode)childNode).getUserObject())) {
                        node = (DefaultMutableTreeNode)childNode;
                    } else {
                        DefaultMutableTreeNode localNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.LOCAL);
                        node.add(localNode);
                        node = localNode;
                    }
                }
                CheckedTreeNode suiteNode = new CheckedTreeNode((Object)coverageSuite);
                suiteNode.setChecked(true);
                node.add((MutableTreeNode)suiteNode);
                TreeUtil.sort((DefaultMutableTreeNode)node, (Comparator)new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof CheckedTreeNode && o2 instanceof CheckedTreeNode) {
                            Object userObject1 = ((CheckedTreeNode)o1).getUserObject();
                            Object userObject2 = ((CheckedTreeNode)o2).getUserObject();
                            if (userObject1 instanceof CoverageSuite && userObject2 instanceof CoverageSuite) {
                                String presentableName1 = ((CoverageSuite)userObject1).getPresentableName();
                                String presentableName2 = ((CoverageSuite)userObject2).getPresentableName();
                                return presentableName1.compareToIgnoreCase(presentableName2);
                            }
                        }
                        return 0;
                    }
                });
                CoverageSuiteChooserDialog.this.updateTree();
                TreeUtil.selectNode((JTree)CoverageSuiteChooserDialog.this.mySuitesTree, (TreeNode)suiteNode);
            }
        }
    }

    private class NoCoverageAction
    extends DialogWrapper.DialogWrapperAction {
        public NoCoverageAction() {
            super((DialogWrapper)CoverageSuiteChooserDialog.this, "&No Coverage");
        }

        protected void doAction(ActionEvent e) {
            CoverageSuiteChooserDialog.this.myCoverageManager.chooseSuitesBundle(null);
            CoverageSuiteChooserDialog.this.close(0);
        }
    }

    private static class SuitesRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private SuitesRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (value instanceof CheckedTreeNode) {
                Object userObject2 = ((CheckedTreeNode)value).getUserObject();
                if (userObject2 instanceof CoverageSuite) {
                    CoverageSuite suite = (CoverageSuite)userObject2;
                    this.getTextRenderer().append(suite.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String date = " (" + DateFormatUtil.formatPrettyDateTime((long)suite.getLastCoverageTimeStamp()) + ")";
                    this.getTextRenderer().append(date, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String) {
                this.getTextRenderer().append((String)userObject);
            }
        }
    }
}

