/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.tools.idea.jps.model.JpsAndroidGradleModuleExtension;
import com.android.tools.idea.jps.model.JpsGradleModuleExtension;
import com.android.tools.idea.jps.model.impl.JpsAndroidGradleModuleExtensionImpl;
import com.android.tools.idea.jps.model.impl.JpsGradleModuleExtensionImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;

public final class AndroidGradleJps {
    private static final String COMPILER_NAME = "Gradle";

    private AndroidGradleJps() {
    }

    public static JpsAndroidGradleModuleExtension getFirstExtension(ModuleChunk chunk) {
        for (JpsModule module : chunk.getModules()) {
            JpsAndroidGradleModuleExtension extension = AndroidGradleJps.getExtension(module);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }

    public static boolean hasAndroidGradleFacet(JpsProject project) {
        for (JpsModule module : project.getModules()) {
            if (AndroidGradleJps.getExtension(module) == null) continue;
            return true;
        }
        return false;
    }

    public static JpsAndroidGradleModuleExtension getExtension(JpsModule module) {
        return (JpsAndroidGradleModuleExtension)module.getContainer().getChild(JpsAndroidGradleModuleExtensionImpl.KIND);
    }

    public static JpsGradleModuleExtension getOrCreateGradleSystemExtension(JpsModule module) {
        JpsGradleModuleExtension extension = AndroidGradleJps.getGradleSystemExtension(module);
        if (extension == null) {
            extension = new JpsGradleModuleExtensionImpl();
            module.getContainer().setChild(JpsGradleModuleExtensionImpl.ROLE, (JpsElement)extension);
        }
        return extension;
    }

    public static JpsGradleModuleExtension getGradleSystemExtension(JpsModule module) {
        return (JpsGradleModuleExtension)module.getContainer().getChild(JpsGradleModuleExtensionImpl.ROLE);
    }

    public static JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getFirstAndroidSdk(ModuleChunk chunk) {
        for (JpsModule module : chunk.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
            if (sdk == null) continue;
            return sdk;
        }
        return null;
    }

    public static CompilerMessage createCompilerMessage(BuildMessage.Kind kind, String text) {
        return new CompilerMessage(COMPILER_NAME, kind, text);
    }

    public static List<CompilerMessage> createCompilerMessages(Message message) {
        BuildMessage.Kind kind;
        switch (message.getKind()) {
            case INFO: {
                kind = BuildMessage.Kind.INFO;
                break;
            }
            case WARNING: {
                kind = BuildMessage.Kind.WARNING;
                break;
            }
            case ERROR: {
                kind = BuildMessage.Kind.ERROR;
                break;
            }
            default: {
                kind = BuildMessage.Kind.PROGRESS;
            }
        }
        ArrayList<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
        for (SourceFilePosition filePosition : message.getSourceFilePositions()) {
            File sourceFile = filePosition.getFile().getSourceFile();
            String sourceFilePath = sourceFile != null ? sourceFile.getAbsolutePath() : null;
            SourcePosition pos = filePosition.getPosition();
            compilerMessages.add(new CompilerMessage(COMPILER_NAME, kind, message.getText().trim(), sourceFilePath, (long)pos.getStartOffset(), (long)pos.getEndOffset(), (long)pos.getEndOffset(), (long)pos.getEndLine(), (long)pos.getEndColumn()));
        }
        return Collections.unmodifiableList(compilerMessages);
    }
}

